/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client;

import appeng.api.util.AEColor;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.render.StaticItemColor;
import appeng.client.render.crafting.AbstractCraftingUnitModelProvider;
import appeng.client.render.crafting.CraftingCubeModel;
import appeng.hooks.BuiltInModelHooks;
import appeng.init.client.InitScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.FluidType;
import net.pedroksl.advanced_ae.AdvancedAE;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.client.gui.AdvPatternEncoderScreen;
import net.pedroksl.advanced_ae.client.gui.AdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.OutputDirectionScreen;
import net.pedroksl.advanced_ae.client.gui.PortableWorkbenchScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorFilterConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorMagnetScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumArmorNumInputConfigScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumComputerScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterConfigPatternScreen;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;
import net.pedroksl.advanced_ae.client.gui.ReactionChamberScreen;
import net.pedroksl.advanced_ae.client.gui.SetAmountScreen;
import net.pedroksl.advanced_ae.client.gui.SmallAdvPatternProviderScreen;
import net.pedroksl.advanced_ae.client.gui.StockExportBusScreen;
import net.pedroksl.advanced_ae.client.renderer.AAECraftingUnitModelProvider;
import net.pedroksl.advanced_ae.client.renderer.ReactionChamberTESR;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitType;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.definitions.FluidDefinition;

@Mod(value="advanced_ae", dist={Dist.CLIENT})
public class AAEClient
extends AdvancedAE {
    private static AAEClient INSTANCE;

    public AAEClient(IEventBus eventBus, ModContainer container) {
        super(eventBus, container);
        eventBus.addListener(AAEClient::initScreens);
        eventBus.addListener(AAEClient::initItemBlockRenderTypes);
        eventBus.addListener(AAEClient::initItemColours);
        eventBus.addListener(AAEClient::initRenderers);
        eventBus.addListener(AAEClient::initClientExtensions);
        eventBus.addListener(this::registerHotkeys);
        INSTANCE = this;
        NeoForge.EVENT_BUS.addListener(e -> {
            this.tickPinnedKeys(Minecraft.getInstance());
            Hotkeys.checkHotkeys();
        });
    }

    private static void initScreens(RegisterMenuScreensEvent event) {
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_COMPUTER, QuantumComputerScreen::new, (String)"/screens/quantum_computer.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.ADV_PATTERN_PROVIDER, AdvPatternProviderScreen::new, (String)"/screens/adv_pattern_provider.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.SMALL_ADV_PATTERN_PROVIDER, SmallAdvPatternProviderScreen::new, (String)"/screens/small_adv_pattern_provider.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.ADV_PATTERN_ENCODER, AdvPatternEncoderScreen::new, (String)"/screens/adv_pattern_encoder.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.REACTION_CHAMBER, ReactionChamberScreen::new, (String)"/screens/reaction_chamber.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_CRAFTER, QuantumCrafterScreen::new, (String)"/screens/quantum_crafter.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.STOCK_EXPORT_BUS, StockExportBusScreen::new, (String)"/screens/stock_export_bus.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.OUTPUT_DIRECTION, OutputDirectionScreen::new, (String)"/screens/output_direction.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.CRAFTER_PATTERN_CONFIG, QuantumCrafterConfigPatternScreen::new, (String)"/screens/quantum_crafter_pattern_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.SET_AMOUNT, SetAmountScreen::new, (String)"/screens/aae_set_amount.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_CONFIG, QuantumArmorConfigScreen::new, (String)"/screens/quantum_armor_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_NUM_INPUT, QuantumArmorNumInputConfigScreen::new, (String)"/screens/quantum_armor_num_input_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_FILTER_CONFIG, QuantumArmorFilterConfigScreen::new, (String)"/screens/quantum_armor_filter_config.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.QUANTUM_ARMOR_MAGNET, QuantumArmorMagnetScreen::new, (String)"/screens/quantum_armor_magnet.json");
        InitScreens.register((RegisterMenuScreensEvent)event, AAEMenus.PORTABLE_WORKBENCH, PortableWorkbenchScreen::new, (String)"/screens/portable_workbench.json");
    }

    private static void initItemBlockRenderTypes(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            for (AAECraftingUnitType type : AAECraftingUnitType.values()) {
                if (type != AAECraftingUnitType.STRUCTURE) continue;
                BuiltInModelHooks.addBuiltInModel((ResourceLocation)AdvancedAE.makeId("block/crafting/" + type.getAffix() + "_formed"), (UnbakedModel)new CraftingCubeModel((AbstractCraftingUnitModelProvider)new AAECraftingUnitModelProvider(type)));
            }
            ItemBlockRenderTypes.setRenderLayer(AAEFluids.QUANTUM_INFUSION.source(), (RenderType)RenderType.translucent());
            ItemBlockRenderTypes.setRenderLayer(AAEFluids.QUANTUM_INFUSION.flowing(), (RenderType)RenderType.translucent());
        });
    }

    private void tickPinnedKeys(Minecraft minecraft) {
        if (minecraft.screen == null) {
            PinnedKeys.prune();
        }
    }

    @Override
    public void registerHotkey(String id) {
        Hotkeys.registerHotkey(id);
    }

    private void registerHotkeys(RegisterKeyMappingsEvent e) {
        Hotkeys.finalizeRegistration(arg_0 -> ((RegisterKeyMappingsEvent)e).register(arg_0));
    }

    private static void initItemColours(RegisterColorHandlersEvent.Item event) {
        event.register(AAEClient.makeOpaque((ItemColor)new StaticItemColor(AEColor.TRANSPARENT)), new ItemLike[]{AAEItems.THROUGHPUT_MONITOR.asItem()});
        for (FluidDefinition<?, ?> bucket : AAEFluids.getFluids()) {
            event.getItemColors().register((stack, index) -> {
                Item patt0$temp;
                if (index == 1 && (patt0$temp = stack.getItem()) instanceof BucketItem) {
                    BucketItem bucketItem = (BucketItem)patt0$temp;
                    return IClientFluidTypeExtensions.of((Fluid)bucketItem.content).getTintColor();
                }
                return -1;
            }, new ItemLike[]{bucket.bucketItem()});
        }
    }

    private static void initRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(AAEBlockEntities.REACTION_CHAMBER.get(), ReactionChamberTESR::new);
    }

    private static void initClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerFluidType((IClientFluidTypeExtensions)AAEFluids.QUANTUM_INFUSION.fluidType(), new FluidType[]{AAEFluids.QUANTUM_INFUSION.fluidType()});
    }

    private static ItemColor makeOpaque(ItemColor itemColor) {
        return (stack, tintIndex) -> FastColor.ARGB32.opaque((int)itemColor.getColor(stack, tintIndex));
    }

    public static AAEClient instance() {
        return INSTANCE;
    }
}

