/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae;

import appeng.api.AECapabilities;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.parts.RegisterPartCapabilitiesEvent;
import appeng.api.parts.RegisterPartCapabilitiesEventInternal;
import appeng.api.upgrades.Upgrades;
import appeng.blockentity.AEBaseInvBlockEntity;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import appeng.core.AELog;
import appeng.core.definitions.AEBlockEntities;
import appeng.core.definitions.AEItems;
import appeng.core.definitions.ItemDefinition;
import appeng.items.tools.powered.powersink.PoweredItemCapabilities;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoader;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.pedroksl.advanced_ae.common.definitions.AAEBlockEntities;
import net.pedroksl.advanced_ae.common.definitions.AAEBlocks;
import net.pedroksl.advanced_ae.common.definitions.AAEComponents;
import net.pedroksl.advanced_ae.common.definitions.AAEConfig;
import net.pedroksl.advanced_ae.common.definitions.AAECreativeTab;
import net.pedroksl.advanced_ae.common.definitions.AAEFluids;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEMenus;
import net.pedroksl.advanced_ae.common.items.armors.IGridLinkedItem;
import net.pedroksl.advanced_ae.common.parts.AdvPatternProviderPart;
import net.pedroksl.advanced_ae.common.parts.SmallAdvPatternProviderPart;
import net.pedroksl.advanced_ae.events.AAELivingEntityEvents;
import net.pedroksl.advanced_ae.events.AAEPlayerEvents;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.recipes.InitRecipeSerializers;
import net.pedroksl.advanced_ae.recipes.InitRecipeTypes;
import net.pedroksl.advanced_ae.xmod.Addons;
import net.pedroksl.advanced_ae.xmod.appflux.AppliedFluxPlugin;
import net.pedroksl.advanced_ae.xmod.mekansim.MekanismPlugin;

@Mod(value="advanced_ae", dist={Dist.DEDICATED_SERVER})
public class AdvancedAE {
    public static final String MOD_ID = "advanced_ae";
    static AdvancedAE INSTANCE;

    public AdvancedAE(IEventBus eventBus, ModContainer container) {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
        AAEConfig.register(container);
        AAEBlocks.DR.register(eventBus);
        AAEItems.DR.register(eventBus);
        AAEBlockEntities.DR.register(eventBus);
        AAEFluids.init(eventBus);
        AAEMenus.DR.register(eventBus);
        AAEComponents.DR.register(eventBus);
        AAEMaterials.DR.register(eventBus);
        AAECreativeTab.DR.register(eventBus);
        AAEComponents.init();
        eventBus.addListener(AdvancedAE::initUpgrades);
        eventBus.addListener(AdvancedAE::initCapabilities);
        eventBus.addListener(AAENetworkHandler.INSTANCE::onRegister);
        eventBus.addListener(event -> {
            if (event.getRegistryKey() == Registries.RECIPE_TYPE) {
                InitRecipeTypes.init(event.getRegistry(Registries.RECIPE_TYPE));
            } else if (event.getRegistryKey() == Registries.RECIPE_SERIALIZER) {
                InitRecipeSerializers.init(event.getRegistry(Registries.RECIPE_SERIALIZER));
            }
        });
        eventBus.addListener(this::commonSetup);
        AAEHotkeys.init();
    }

    public static AdvancedAE instance() {
        return INSTANCE;
    }

    public void registerHotkey(String id) {
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register(AAELivingEntityEvents.class);
        NeoForge.EVENT_BUS.register(AAEPlayerEvents.class);
        event.enqueueWork(this::postRegistrationInitialization).whenComplete((res, err) -> {
            if (err != null) {
                AELog.warn((Throwable)err);
            }
        });
    }

    public void postRegistrationInitialization() {
        GridLinkables.register(AAEItems.QUANTUM_HELMET, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_CHESTPLATE, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_LEGGINGS, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
        GridLinkables.register(AAEItems.QUANTUM_BOOTS, (IGridLinkableHandler)IGridLinkedItem.LINKABLE_HANDLER);
    }

    private static void initUpgrades(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.REACTION_CHAMBER, (int)4);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)4);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEBlocks.QUANTUM_CRAFTER, (int)1);
            Upgrades.add((ItemLike)AEItems.SPEED_CARD, AAEItems.STOCK_EXPORT_BUS, (int)4);
            Upgrades.add((ItemLike)AEItems.CAPACITY_CARD, AAEItems.STOCK_EXPORT_BUS, (int)5);
            Upgrades.add((ItemLike)AEItems.REDSTONE_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            Upgrades.add((ItemLike)AEItems.CRAFTING_CARD, AAEItems.STOCK_EXPORT_BUS, (int)1);
            if (Addons.APPFLUX.isLoaded()) {
                AppliedFluxPlugin.init();
            }
        });
    }

    private static void initCapabilities(RegisterCapabilitiesEvent event) {
        for (DeferredHolder deferredHolder : AAEBlockEntities.DR.getEntries()) {
            event.registerBlockEntity(AECapabilities.IN_WORLD_GRID_NODE_HOST, (BlockEntityType)deferredHolder.get(), (be, context) -> (IInWorldGridNodeHost)be);
        }
        for (ItemDefinition itemDefinition : AAEItems.getItems()) {
            Item item = itemDefinition.get();
            if (!(item instanceof IAEItemPowerStorage)) continue;
            IAEItemPowerStorage powerStorage = (IAEItemPowerStorage)item;
            event.registerItem(Capabilities.EnergyStorage.ITEM, (object, context) -> new PoweredItemCapabilities(object, powerStorage), new ItemLike[]{itemDefinition});
        }
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, AAEBlockEntities.ADV_PATTERN_PROVIDER.get(), (be, context) -> be.getLogic().getReturnInv());
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, AAEBlockEntities.SMALL_ADV_PATTERN_PROVIDER.get(), (be, context) -> be.getLogic().getReturnInv());
        event.registerBlockEntity(Capabilities.ItemHandler.BLOCK, AAEBlockEntities.REACTION_CHAMBER.get(), AEBaseInvBlockEntity::getExposedItemHandler);
        event.registerBlockEntity(AECapabilities.GENERIC_INTERNAL_INV, AAEBlockEntities.REACTION_CHAMBER.get(), (be, context) -> be.getTank());
        event.registerBlockEntity(Capabilities.EnergyStorage.BLOCK, AAEBlockEntities.REACTION_CHAMBER.get(), AEBasePoweredBlockEntity::getEnergyStorage);
        RegisterPartCapabilitiesEvent partEvent = new RegisterPartCapabilitiesEvent();
        partEvent.addHostType(AEBlockEntities.CABLE_BUS.get());
        partEvent.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.getLogic().getReturnInv(), AdvPatternProviderPart.class);
        partEvent.register(AECapabilities.GENERIC_INTERNAL_INV, (part, context) -> part.getLogic().getReturnInv(), SmallAdvPatternProviderPart.class);
        ModLoader.postEvent((Event)partEvent);
        RegisterPartCapabilitiesEventInternal.register((RegisterPartCapabilitiesEvent)partEvent, (RegisterCapabilitiesEvent)event);
        if (Addons.MEKANISM.isLoaded()) {
            MekanismPlugin.initCap(event);
        }
    }

    public static ResourceLocation makeId(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id);
    }
}

