/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.util;

import cy.jdkdigital.productivebees.util.GeneValue;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;

public class ColorUtil {
    private static final Map<Integer, float[]> colorCache = new HashMap<Integer, float[]>();
    private static final Map<String, Integer> stringColorCache = new HashMap<String, Integer>();

    public static Integer getCacheColor(String color) {
        if (!stringColorCache.containsKey(color)) {
            stringColorCache.put(color, ((TextColor)TextColor.parseColor((String)color).result().get()).getValue());
        }
        return stringColorCache.get(color);
    }

    public static float[] getCacheColor(int color) {
        if (!colorCache.containsKey(color)) {
            colorCache.put(color, ColorUtil.getComponents(color));
        }
        return colorCache.get(color);
    }

    public static float[] getComponents(int color) {
        float[] f = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, (float)(color >> 24 & 0xFF) / 255.0f};
        return f;
    }

    public static int getCycleColor(int color, int color2, int tickCount, float partialTicks) {
        float f3 = ((float)(tickCount % 25) + partialTicks) / 25.0f;
        return (int)((float)color * (1.0f - f3) + (float)color2 * f3);
    }

    public static ChatFormatting getBeeTypeColor(String type) {
        return switch (type) {
            case "hive" -> ChatFormatting.YELLOW;
            case "solitary" -> ChatFormatting.GRAY;
            default -> ChatFormatting.WHITE;
        };
    }

    public static ChatFormatting getAttributeColor(GeneValue level) {
        return switch (level) {
            case GeneValue.TEMPER_NORMAL -> ChatFormatting.BLUE;
            case GeneValue.PRODUCTIVITY_MEDIUM -> ChatFormatting.BLUE;
            case GeneValue.ENDURANCE_NORMAL -> ChatFormatting.BLUE;
            case GeneValue.TEMPER_AGGRESSIVE -> ChatFormatting.LIGHT_PURPLE;
            case GeneValue.PRODUCTIVITY_HIGH -> ChatFormatting.LIGHT_PURPLE;
            case GeneValue.WEATHER_TOLERANCE_RAIN -> ChatFormatting.LIGHT_PURPLE;
            case GeneValue.ENDURANCE_MEDIUM -> ChatFormatting.LIGHT_PURPLE;
            case GeneValue.BEHAVIOR_NOCTURNAL -> ChatFormatting.LIGHT_PURPLE;
            case GeneValue.TEMPER_HOSTILE -> ChatFormatting.RED;
            case GeneValue.PRODUCTIVITY_VERY_HIGH -> ChatFormatting.RED;
            case GeneValue.WEATHER_TOLERANCE_ANY -> ChatFormatting.RED;
            case GeneValue.ENDURANCE_STRONG -> ChatFormatting.RED;
            case GeneValue.BEHAVIOR_METATURNAL -> ChatFormatting.RED;
            case GeneValue.TEMPER_PASSIVE -> ChatFormatting.GREEN;
            case GeneValue.PRODUCTIVITY_NORMAL -> ChatFormatting.GREEN;
            case GeneValue.WEATHER_TOLERANCE_NONE -> ChatFormatting.GREEN;
            case GeneValue.ENDURANCE_WEAK -> ChatFormatting.GREEN;
            case GeneValue.BEHAVIOR_DIURNAL -> ChatFormatting.GREEN;
            default -> ChatFormatting.GREEN;
        };
    }
}

