/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.util.BeeCreator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.common.conditions.ICondition;

public class BeeReloadListener
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final BeeReloadListener INSTANCE = new BeeReloadListener();
    public ICondition.IContext context;
    private Map<ResourceLocation, CompoundTag> BEE_DATA = new HashMap<ResourceLocation, CompoundTag>();
    private Map<String, JsonObject> BEE_CONDITIONS = new HashMap<String, JsonObject>();

    public BeeReloadListener() {
        super(GSON, "productivebees");
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager manager, ProfilerFiller profiler) {
        Map map = super.prepare(manager, profiler);
        for (Map.Entry entry : map.entrySet()) {
            ResourceLocation id = (ResourceLocation)entry.getKey();
            String simpleId = id.getPath().contains("/") ? id.getNamespace() + ":" + id.getPath().substring(id.getPath().lastIndexOf("/") + 1) : id.toString();
            this.BEE_CONDITIONS.put(simpleId, ((JsonElement)entry.getValue()).getAsJsonObject());
            this.BEE_CONDITIONS.put(id.toString(), ((JsonElement)entry.getValue()).getAsJsonObject());
        }
        return map;
    }

    protected void apply(Map<ResourceLocation, JsonElement> dataMap, @Nonnull ResourceManager resourceManager, ProfilerFiller profiler) {
        profiler.push("BeeReloadListener");
        ConditionalOps registryOps = this.makeConditionalOps();
        HashMap<ResourceLocation, CompoundTag> data = new HashMap<ResourceLocation, CompoundTag>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : dataMap.entrySet()) {
            ResourceLocation id = entry.getKey();
            try {
                boolean enabled = true;
                JsonObject jsonValue = entry.getValue().getAsJsonObject();
                if (jsonValue.has("conditions")) {
                    DataResult conditions = ICondition.LIST_CODEC.decode((DynamicOps)registryOps, (Object)jsonValue.getAsJsonArray("conditions"));
                    for (ICondition condition : (List)((Pair)conditions.result().get()).getFirst()) {
                        if (condition.test(this.context)) continue;
                        enabled = false;
                    }
                }
                if (!enabled) continue;
                ResourceLocation simpleId = id.getPath().contains("/") ? ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath().substring(id.getPath().lastIndexOf("/") + 1)) : id;
                CompoundTag nbt = BeeCreator.create(simpleId, jsonValue);
                int i = id.getPath().lastIndexOf("/");
                if (i > 0) {
                    String[] a = new String[]{id.getPath().substring(0, i), id.getPath().substring(i)};
                    nbt.putString("group", a[0].substring(0, 1).toUpperCase() + a[0].substring(1));
                } else {
                    nbt.putString("group", "");
                }
                data.remove(simpleId.toString());
                data.put(simpleId, nbt);
                ProductiveBees.LOGGER.debug("Adding to bee data " + String.valueOf(simpleId));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.debug("Skipping loading bee {} as its conditions were invalid", (Object)id);
                throw e;
            }
        }
        this.setData(data);
        profiler.popPush("BeeReloadListener");
    }

    public CompoundTag getData(ResourceLocation id) {
        return this.BEE_DATA.get(id);
    }

    @Deprecated
    public CompoundTag getData(String id) {
        return this.BEE_DATA.get(ResourceLocation.parse((String)id));
    }

    public Map<ResourceLocation, CompoundTag> getData() {
        return this.BEE_DATA;
    }

    public JsonObject getCondition(String id) {
        return this.BEE_CONDITIONS.get(id);
    }

    public void setData(Map<ResourceLocation, CompoundTag> data) {
        ProductiveBees.LOGGER.info("setting bee data");
        this.BEE_DATA = data;
        if (ModList.get().isLoaded("patchouli")) {
            // empty if block
        }
    }
}

