/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.common.block.SolitaryNest;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.gen.feature.WoodNestDecorator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class SolitaryNestTreeFeature
extends TreeFeature {
    public SolitaryNestTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public boolean place(TreeConfiguration pConfig, final WorldGenLevel pLevel, ChunkGenerator pChunkGenerator, RandomSource pRandom, BlockPos pOrigin) {
        HashSet rootPositions = Sets.newHashSet();
        HashSet logPositions = Sets.newHashSet();
        final HashSet leavesPositions = Sets.newHashSet();
        HashSet set3 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> rootPlacer = (pos, state) -> {
            rootPositions.add(pos.immutable());
            pLevel.setBlock(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> trunkPlacer = (pos, state) -> {
            logPositions.add(pos.immutable());
            pLevel.setBlock(pos, state, 19);
        };
        BiConsumer<BlockPos, BlockState> leavesPlacer = (pos, state) -> {
            leavesPositions.add(pos.immutable());
            pLevel.setBlock(pos, state, 19);
        };
        FoliagePlacer.FoliageSetter foliageSetter = new FoliagePlacer.FoliageSetter(){

            public void set(BlockPos pos, BlockState state) {
                leavesPositions.add(pos.immutable());
                pLevel.setBlock(pos, state, 19);
            }

            public boolean isSet(BlockPos pos) {
                return leavesPositions.contains(pos);
            }
        };
        BiConsumer<BlockPos, BlockState> decorationPlacer = (pos, state) -> {
            set3.add(pos.immutable());
            pLevel.setBlock(pos, state, 19);
        };
        boolean flag = this.doPlace(pLevel, pRandom, pOrigin, rootPlacer, trunkPlacer, foliageSetter, pConfig);
        if (!(!flag || logPositions.isEmpty() && leavesPositions.isEmpty())) {
            if (!pConfig.decorators.isEmpty()) {
                TreeDecorator.Context decoratorContext = new TreeDecorator.Context((LevelSimulatedReader)pLevel, decorationPlacer, pRandom, (Set)logPositions, (Set)leavesPositions, (Set)rootPositions);
                pConfig.decorators.forEach(decorator -> {
                    if (decorator instanceof WoodNestDecorator) {
                        Block nest;
                        WoodNestDecorator woodNestDecorator = (WoodNestDecorator)((Object)decorator);
                        List logList = logPositions.stream().toList();
                        BlockState logBlock = pLevel.getBlockState((BlockPos)logList.get(0));
                        if (logBlock.getBlock().equals(Blocks.DIRT)) {
                            logBlock = pLevel.getBlockState(((BlockPos)logList.get(0)).above());
                        }
                        if ((nest = SolitaryNest.BLOCK_TO_NEST.get().get(logBlock.getBlock())) instanceof WoodNest) {
                            WoodNest woodNest = (WoodNest)nest;
                            woodNestDecorator.setNest(woodNest.defaultBlockState());
                            woodNestDecorator.setBeeRecipes(SolitaryNest.getSpawningRecipes(woodNest, (Level)pLevel.getLevel(), (Holder<Biome>)pLevel.getBiome(pOrigin), ItemStack.EMPTY));
                        } else {
                            woodNestDecorator.setNest(null);
                        }
                    }
                    decorator.place(decoratorContext);
                });
            }
            return BoundingBox.encapsulatingPositions((Iterable)Iterables.concat((Iterable)rootPositions, (Iterable)logPositions, (Iterable)leavesPositions, (Iterable)set3)).map(boundingBox -> {
                DiscreteVoxelShape discretevoxelshape = TreeFeature.updateLeaves((LevelAccessor)pLevel, (BoundingBox)boundingBox, (Set)logPositions, (Set)set3, (Set)rootPositions);
                StructureTemplate.updateShapeAtEdge((LevelAccessor)pLevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)boundingBox.minX(), (int)boundingBox.minY(), (int)boundingBox.minZ());
                return true;
            }).orElse(false);
        }
        return false;
    }
}

