/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class ReedSolitaryNestFeature
extends SolitaryNestFeature {
    public ReedSolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory) {
        super(configKey, configFactory);
    }

    @Override
    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel world = context.level();
        ChunkGenerator chunkGenerator = context.chunkGenerator();
        RandomSource rand = context.random();
        BlockPos blockPos = context.origin();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.targetStates) {
            BlockState state;
            if (rand.nextFloat() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                return false;
            }
            blockPos = blockPos.above(chunkGenerator.getSpawnHeight((LevelHeightAccessor)world));
            while (blockPos.getY() < 127 && !world.isEmptyBlock(blockPos)) {
                blockPos = blockPos.above();
            }
            blockPos = blockPos.above(rand.nextInt(2));
            BlockPos newPos = null;
            block2: for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    newPos = blockPos.offset(x, 0, z);
                    if (targetBlockState.target.test(world.getBlockState(newPos), rand)) break block2;
                    newPos = null;
                }
            }
            if (newPos == null) continue;
            if (!targetBlockState.target.test(world.getBlockState(newPos.below()), rand)) {
                newPos = newPos.above();
            }
            if (!targetBlockState.target.test(state = this.placeOntop ? world.getBlockState(newPos.below()) : world.getBlockState(newPos), rand)) continue;
            return this.placeNest(world, newPos, targetBlockState.state, rand);
        }
        return false;
    }
}

