/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.gen.feature;

import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.gen.feature.SolitaryNestFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;

public class CavernSolitaryNestFeature
extends SolitaryNestFeature {
    private boolean top;

    public CavernSolitaryNestFeature(String configKey, Codec<ReplaceBlockConfiguration> configFactory, boolean top) {
        super(configKey, configFactory);
        this.top = top;
    }

    @Override
    public boolean place(FeaturePlaceContext<ReplaceBlockConfiguration> context) {
        WorldGenLevel world = context.level();
        RandomSource rand = context.random();
        BlockPos blockPos = context.origin();
        ReplaceBlockConfiguration featureConfig = (ReplaceBlockConfiguration)context.config();
        for (OreConfiguration.TargetBlockState targetBlockState : featureConfig.targetStates) {
            BlockState state;
            if (rand.nextFloat() > ((Double)ProductiveBeesConfig.WORLD_GEN.nestConfigs.get(this.configKey).get()).floatValue()) {
                return false;
            }
            blockPos = blockPos.south(rand.nextInt(14)).east(rand.nextInt(14));
            BlockStatePredicate matcher = BlockStatePredicate.forBlock((Block)targetBlockState.state.getBlock());
            while (blockPos.getY() < 127 && !matcher.test(world.getBlockState(blockPos))) {
                blockPos = blockPos.above();
            }
            if (this.top) {
                while (blockPos.getY() < 127 && !world.isEmptyBlock(blockPos)) {
                    blockPos = blockPos.above();
                }
                blockPos = blockPos.below();
            }
            if (!targetBlockState.target.test(state = this.placeOntop ? world.getBlockState(blockPos.below()) : world.getBlockState(blockPos), rand)) continue;
            return this.placeNest(world, blockPos, targetBlockState.state, rand);
        }
        return false;
    }
}

