/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.event;

import com.mojang.serialization.DataResult;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.client.model.BeeNestHelmetModel;
import cy.jdkdigital.productivebees.client.particle.FallingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.LavaNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PoppingNectarParticle;
import cy.jdkdigital.productivebees.client.particle.PortalNectarParticle;
import cy.jdkdigital.productivebees.client.particle.RisingNectarParticle;
import cy.jdkdigital.productivebees.client.render.block.AmberBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.BottlerBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.CentrifugeBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.FeederBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.block.JarBlockEntityRenderer;
import cy.jdkdigital.productivebees.client.render.entity.DyeBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.HoarderBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.ProductiveBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.RancherBeeRenderer;
import cy.jdkdigital.productivebees.client.render.entity.model.HoarderBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumCrystalBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumElvisBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumFoliageBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.MediumShellBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ProductiveBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.RancherBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SlimyBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.SmallBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.ThiccBeeModel;
import cy.jdkdigital.productivebees.client.render.entity.model.TinyBeeModel;
import cy.jdkdigital.productivebees.common.block.CanvasBeehive;
import cy.jdkdigital.productivebees.common.block.CanvasExpansionBox;
import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.block.entity.CanvasBeehiveBlockEntity;
import cy.jdkdigital.productivebees.common.block.entity.CanvasExpansionBoxBlockEntity;
import cy.jdkdigital.productivebees.common.block.nest.WoodNest;
import cy.jdkdigital.productivebees.common.item.BeeBomb;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.item.HoneyTreat;
import cy.jdkdigital.productivebees.common.item.Honeycomb;
import cy.jdkdigital.productivebees.common.item.NestLocator;
import cy.jdkdigital.productivebees.common.item.SpawnEgg;
import cy.jdkdigital.productivebees.compat.geckolib.client.render.GeckoBeeRenderer;
import cy.jdkdigital.productivebees.container.gui.AdvancedBeehiveScreen;
import cy.jdkdigital.productivebees.container.gui.BottlerScreen;
import cy.jdkdigital.productivebees.container.gui.BreedingChamberScreen;
import cy.jdkdigital.productivebees.container.gui.CatcherScreen;
import cy.jdkdigital.productivebees.container.gui.CentrifugeScreen;
import cy.jdkdigital.productivebees.container.gui.CryoStasisScreen;
import cy.jdkdigital.productivebees.container.gui.FeederScreen;
import cy.jdkdigital.productivebees.container.gui.GeneIndexerScreen;
import cy.jdkdigital.productivebees.container.gui.HoneyGeneratorScreen;
import cy.jdkdigital.productivebees.container.gui.IncubatorScreen;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModContainerTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModParticles;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivebees.util.ColorUtil;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.common.item.AbstractUpgradeItem;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;

@EventBusSubscriber(modid="productivebees", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public class ClientModEventHandler {
    @SubscribeEvent
    public static void tabContents(BuildCreativeModeTabContentsEvent event) {
        ResourceLocation beeType;
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY)) {
            for (DeferredHolder deferredHolder : ProductiveBees.ITEMS.getEntries()) {
                if (deferredHolder.equals(ModItems.CONFIGURABLE_HONEYCOMB) || deferredHolder.equals(ModItems.CONFIGURABLE_COMB_BLOCK) || deferredHolder.equals(ModItems.CONFIGURABLE_SPAWN_EGG) || deferredHolder.equals(ModItems.GENE) || deferredHolder.equals(ModItems.GENE_BOTTLE) || deferredHolder.equals(ModItems.ADV_BREED_ALL_BEES) || deferredHolder.equals(ModItems.ADV_BREED_BEE) || deferredHolder.equals(ModItems.UPGRADE_BASE) || deferredHolder.get() instanceof SpawnEggItem || deferredHolder.get() instanceof AbstractUpgradeItem) continue;
                event.accept(new ItemStack((ItemLike)deferredHolder.get(), 1));
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (ResourceLocation)entry.getKey();
                if (!((CompoundTag)entry.getValue()).getBoolean("createComb")) continue;
                ItemStack comb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                BeeCreator.setType(beeType, comb);
                event.accept(comb);
                ItemStack combBlock = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
                BeeCreator.setType(beeType, combBlock);
                event.accept(combBlock);
            }
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_MEDIUM, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_HIGH, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.PRODUCTIVITY, GeneValue.PRODUCTIVITY_VERY_HIGH, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_NONE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_RAIN, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.WEATHER_TOLERANCE, GeneValue.WEATHER_TOLERANCE_ANY, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_DIURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_NOCTURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.BEHAVIOR, GeneValue.BEHAVIOR_METATURNAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_PASSIVE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_HOSTILE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.TEMPER, GeneValue.TEMPER_AGGRESSIVE, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_WEAK, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_NORMAL, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_MEDIUM, 1, 100));
            event.accept(Gene.getStack(GeneAttribute.ENDURANCE, GeneValue.ENDURANCE_STRONG, 1, 100));
        }
        if (event.getTabKey().equals(ProductiveBees.TAB_KEY) || event.getTabKey().equals(CreativeModeTabs.SPAWN_EGGS)) {
            for (DeferredHolder deferredHolder : ModItems.SPAWN_EGGS) {
                if (deferredHolder.equals(ModItems.CONFIGURABLE_SPAWN_EGG)) continue;
                event.accept(new ItemStack((Holder)deferredHolder));
            }
            for (Map.Entry entry : BeeReloadListener.INSTANCE.getData().entrySet()) {
                beeType = (ResourceLocation)entry.getKey();
                event.accept(BeeCreator.getSpawnEgg(beeType));
            }
        }
    }

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        Item item;
        for (DeferredHolder<Item, ? extends Item> eggItem : ModItems.SPAWN_EGGS) {
            item = (Item)eggItem.get();
            if (!(item instanceof SpawnEgg)) continue;
            event.register((stack, tintIndex) -> ((SpawnEgg)item).getColor(tintIndex, stack), new ItemLike[]{item});
        }
        for (DeferredHolder registryItem : ProductiveBees.ITEMS.getEntries()) {
            item = (Item)registryItem.get();
            if (item instanceof Honeycomb) {
                event.register(((Honeycomb)item)::getColor, new ItemLike[]{item});
                continue;
            }
            if (!(item instanceof BlockItem)) continue;
            Block block = ((BlockItem)item).getBlock();
            if (block instanceof CombBlock) {
                event.register((stack, tintIndex) -> ((CombBlock)block).getColor(stack), new ItemLike[]{item});
            }
            if (!(block instanceof WoodNest)) continue;
            event.register((stack, tintIndex) -> ((WoodNest)block).getColor(tintIndex), new ItemLike[]{block});
        }
        event.register((stack, tintIndex) -> {
            BlockState blockstate = ((BlockItem)stack.getItem()).getBlock().defaultBlockState();
            return event.getBlockColors().getColor(blockstate, null, null, tintIndex);
        }, new ItemLike[]{(ItemLike)ModBlocks.BUMBLE_BEE_NEST.get()});
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (ProductiveBees.includeMod(modid)) {
                strings.forEach((name, type) -> {
                    if (!type.hasTexture()) {
                        name = modid.equals("productivebees") ? name : modid + "_" + name;
                        DataResult primary = TextColor.parseColor((String)type.primary());
                        event.register((stack, tintIndex) -> tintIndex == 0 ? ((TextColor)primary.result().get()).getValue() : -1, new ItemLike[]{(ItemLike)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get(), (ItemLike)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get()});
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> event.register((stack, tintIndex) -> {
            BlockItem blockItem;
            Item patt0$temp;
            if (tintIndex == 0 && (patt0$temp = stack.getItem()) instanceof BlockItem && ((blockItem = (BlockItem)patt0$temp).getBlock() instanceof CanvasBeehive || blockItem.getBlock() instanceof CanvasExpansionBox) && stack.has(DataComponents.DYED_COLOR)) {
                return ((DyedItemColor)stack.get(DataComponents.DYED_COLOR)).rgb();
            }
            return 0xFFFFFF;
        }, new ItemLike[]{(ItemLike)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get(), (ItemLike)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get()}));
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)lightReader, (BlockPos)pos) : -1, new Block[]{(Block)ModBlocks.SUGAR_CANE_NEST.get()});
        event.register((blockState, lightReader, pos, tintIndex) -> lightReader != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)lightReader, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)ModBlocks.BUMBLE_BEE_NEST.get()});
        for (DeferredHolder registryBlock : ProductiveBees.BLOCKS.getEntries()) {
            Block block = (Block)registryBlock.get();
            if (block instanceof CombBlock) {
                event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 ? ((CombBlock)block).getColor(lightReader, pos) : -1, new Block[]{block});
            }
            if (!(block instanceof WoodNest)) continue;
            event.register((blockState, lightReader, pos, tintIndex) -> ((WoodNest)block).getColor(tintIndex), new Block[]{block});
        }
        ModBlocks.HIVELIST.forEach((modid, strings) -> {
            if (ProductiveBees.includeMod(modid)) {
                strings.forEach((name, type) -> {
                    if (!type.hasTexture()) {
                        name = modid.equals("productivebees") ? name : modid + "_" + name;
                        event.register((blockState, lightReader, pos, tintIndex) -> tintIndex == 0 && type.primary() != null ? ColorUtil.getCacheColor(type.primary()) : -1, new Block[]{(Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get(), (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get()});
                    }
                });
            }
        });
        ModBlocks.hiveStyles.forEach(style -> event.register((blockState, lightReader, pos, tintIndex) -> {
            if (tintIndex == 0 && pos != null && (blockState.getBlock() instanceof CanvasBeehive || blockState.getBlock() instanceof CanvasExpansionBox) && lightReader != null) {
                BlockEntity patt0$temp = lightReader.getBlockEntity(pos);
                if (patt0$temp instanceof CanvasBeehiveBlockEntity) {
                    CanvasBeehiveBlockEntity canvasBlockEntity = (CanvasBeehiveBlockEntity)patt0$temp;
                    return canvasBlockEntity.getColor(tintIndex);
                }
                BlockEntity patt1$temp = lightReader.getBlockEntity(pos);
                if (patt1$temp instanceof CanvasExpansionBoxBlockEntity) {
                    CanvasExpansionBoxBlockEntity canvasBlockEntity = (CanvasExpansionBoxBlockEntity)patt1$temp;
                    return canvasBlockEntity.getColor(tintIndex);
                }
            }
            return -1;
        }, new Block[]{(Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get(), (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get()}));
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_MAIN_LAYER, ProductiveBeeModel::createBodyLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_HOARDER_LAYER, HoarderBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_RANCHER_LAYER, RancherBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_THICC_LAYER, ThiccBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_LAYER, MediumBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_CRYSTAL_LAYER, MediumCrystalBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_SHELL_LAYER, MediumShellBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_DEFAULT_FOLIAGE_LAYER, MediumFoliageBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_ELVIS_LAYER, MediumElvisBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIM_LAYER, SlimBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SLIMY_LAYER, SlimyBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_SMALL_LAYER, SmallBeeModel::createLayer);
        event.registerLayerDefinition(ProductiveBeeRenderer.PB_TINY_LAYER, TinyBeeModel::createLayer);
        event.registerLayerDefinition(BeeNestHelmetModel.LAYER_LOCATION, BeeNestHelmetModel::createBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRendering(EntityRenderersEvent.RegisterRenderers event) {
        for (DeferredHolder registryObject : ModEntities.HIVE_BEES.getEntries()) {
            EntityType bee = (EntityType)registryObject.get();
            String key = bee.getDescriptionId();
            if (key.contains("dye_bee")) {
                event.registerEntityRenderer(bee, DyeBeeRenderer::new);
                continue;
            }
            if (key.contains("rancher_bee") || key.contains("farmer_bee")) {
                event.registerEntityRenderer(bee, RancherBeeRenderer::new);
                continue;
            }
            if (key.contains("hoarder_bee")) {
                event.registerEntityRenderer(bee, HoarderBeeRenderer::new);
                continue;
            }
            if (key.contains("configurable") && ModList.get().isLoaded("geckolib")) {
                event.registerEntityRenderer(bee, GeckoBeeRenderer::new);
                continue;
            }
            event.registerEntityRenderer(bee, ProductiveBeeRenderer::new);
        }
        for (DeferredHolder registryObject : ModEntities.SOLITARY_BEES.getEntries()) {
            event.registerEntityRenderer((EntityType)registryObject.get(), ProductiveBeeRenderer::new);
        }
        event.registerEntityRenderer((EntityType)ModEntities.BEE_BOMB.get(), ThrownItemRenderer::new);
    }

    @SubscribeEvent
    public static void init(RegisterMenuScreensEvent event) {
        event.register((MenuType)ModContainerTypes.ADVANCED_BEEHIVE.get(), AdvancedBeehiveScreen::new);
        event.register((MenuType)ModContainerTypes.CENTRIFUGE.get(), CentrifugeScreen::new);
        event.register((MenuType)ModContainerTypes.POWERED_CENTRIFUGE.get(), CentrifugeScreen::new);
        event.register((MenuType)ModContainerTypes.HEATED_CENTRIFUGE.get(), CentrifugeScreen::new);
        event.register((MenuType)ModContainerTypes.BOTTLER.get(), BottlerScreen::new);
        event.register((MenuType)ModContainerTypes.FEEDER.get(), FeederScreen::new);
        event.register((MenuType)ModContainerTypes.INCUBATOR.get(), IncubatorScreen::new);
        event.register((MenuType)ModContainerTypes.CATCHER.get(), CatcherScreen::new);
        event.register((MenuType)ModContainerTypes.HONEY_GENERATOR.get(), HoneyGeneratorScreen::new);
        event.register((MenuType)ModContainerTypes.GENE_INDEXER.get(), GeneIndexerScreen::new);
        event.register((MenuType)ModContainerTypes.BREEDING_CHAMBER.get(), BreedingChamberScreen::new);
        event.register((MenuType)ModContainerTypes.CRYO_STASIS.get(), CryoStasisScreen::new);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemProperties.register((Item)((Item)ModItems.BEE_CAGE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"filled"), (stack, world, entity, i) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.STURDY_BEE_CAGE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"filled"), (stack, world, entity, i) -> BeeCage.isFilled(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.BEE_BOMB.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"loaded"), (stack, world, entity, i) -> BeeBomb.isLoaded(stack) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.HONEY_TREAT.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"genetic"), (stack, world, entity, i) -> HoneyTreat.hasGene(stack) ? (HoneyTreat.hasBeeType(stack) ? 0.5f : 1.0f) : 0.0f);
            ItemProperties.register((Item)((Item)ModItems.GENE.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"genetic"), (stack, world, entity, i) -> Gene.color(stack));
            ItemProperties.register((Item)((Item)ModItems.NEST_LOCATOR.get()), (ResourceLocation)ResourceLocation.withDefaultNamespace((String)"angle"), (ItemPropertyFunction)new ClampedItemPropertyFunction(){

                public float unclampedCall(@Nonnull ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity player, int i) {
                    if ((player != null || stack.isFramed()) && NestLocator.hasPosition(stack)) {
                        LivingEntity entity;
                        boolean flag = player != null;
                        Object object = entity = flag ? player : stack.getFrame();
                        if (level == null && entity != null && entity.level() instanceof ClientLevel) {
                            level = (ClientLevel)entity.level();
                        }
                        BlockPos pos = NestLocator.getPosition(stack);
                        if (entity != null && level != null && pos != null) {
                            double d1 = flag ? (double)entity.getYRot() : this.getFrameRotation((ItemFrame)entity);
                            d1 = Mth.positiveModulo((double)(d1 / 360.0), (double)1.0);
                            double d2 = this.getPositionToAngle(pos, (Entity)entity) / 6.2831854820251465;
                            double d0 = 0.5 - (d1 - 0.25 - d2);
                            return Mth.positiveModulo((float)((float)d0), (float)1.0f);
                        }
                    }
                    return 0.5f;
                }

                private double getFrameRotation(ItemFrame frameEntity) {
                    return Mth.wrapDegrees((int)(180 + frameEntity.getDirection().get2DDataValue() * 90));
                }

                private double getPositionToAngle(BlockPos blockpos, Entity entityIn) {
                    return Math.atan2((double)blockpos.getZ() - entityIn.getZ(), (double)blockpos.getX() - entityIn.getX());
                }
            });
        });
    }

    @SubscribeEvent
    public static void registerParticles(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.COLORED_FALLING_NECTAR.get(), FallingNectarParticle.FallingNectarFactory::new);
        event.registerSpriteSet((ParticleType)ModParticles.COLORED_RISING_NECTAR.get(), RisingNectarParticle.RisingNectarFactory::new);
        event.registerSpriteSet((ParticleType)ModParticles.COLORED_POPPING_NECTAR.get(), PoppingNectarParticle.PoppingNectarFactory::new);
        event.registerSpriteSet((ParticleType)ModParticles.COLORED_LAVA_NECTAR.get(), LavaNectarParticle.LavaNectarFactory::new);
        event.registerSpriteSet((ParticleType)ModParticles.COLORED_PORTAL_NECTAR.get(), PortalNectarParticle.PortalNectarFactory::new);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.CENTRIFUGE.get(), CentrifugeBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.POWERED_CENTRIFUGE.get(), CentrifugeBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.BOTTLER.get(), BottlerBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.FEEDER.get(), FeederBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.JAR.get(), JarBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntityTypes.AMBER.get(), AmberBlockEntityRenderer::new);
    }
}

