/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import cy.jdkdigital.productivebees.common.crafting.ingredient.ComponentIngredient;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import cy.jdkdigital.productivelib.loot.ContainerContentsModifier;
import cy.jdkdigital.productivelib.loot.IngredientModifier;
import cy.jdkdigital.productivelib.loot.ItemLootModifier;
import cy.jdkdigital.productivelib.loot.LootItemKilledByUUIDCondition;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.data.GlobalLootModifierProvider;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootTableIdCondition;

public class LootModifierProvider
extends GlobalLootModifierProvider {
    public LootModifierProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, "productivebees");
    }

    protected void start() {
        this.add("armadillo_scute_wannabee", (IGlobalLootModifier)new ItemLootModifier(this.lootTableConditions(true, "entities/armadillo"), new ItemStack((ItemLike)Items.ARMADILLO_SCUTE), 0.15f), new ICondition[0]);
        this.add("turtle_scute_wannabee", (IGlobalLootModifier)new ItemLootModifier(this.lootTableConditions(true, "entities/turtle"), new ItemStack((ItemLike)Items.TURTLE_SCUTE), 0.15f), new ICondition[0]);
        this.add("wither_nether_star_wannabee", (IGlobalLootModifier)new ItemLootModifier(this.lootTableConditions(true, "entities/wither"), new ItemStack((ItemLike)Items.NETHER_STAR), 0.15f), new ICondition[0]);
        this.add("sniffer_sussy_egg", (IGlobalLootModifier)new IngredientModifier(this.lootTableConditions(false, "gameplay/sniffer_digging"), ComponentIngredient.of(BeeCreator.getSpawnEgg(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"sussy"))), 0.15f, true), new ICondition[0]);
        this.add("sussy_amber_egg", (IGlobalLootModifier)new IngredientModifier(this.lootTableConditions(false, "archaeology/ocean_ruin_cold"), ComponentIngredient.of(BeeCreator.getSpawnEgg(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"amber"))), 0.08f, true), new ICondition[0]);
        this.add("village_chest_sturdy_cage", (IGlobalLootModifier)new ItemLootModifier(this.anyOfConditions("chests/village/village_armorer", "chests/village/village_butcher", "chests/village/village_desert_house", "chests/village/village_fisher", "chests/village/village_plains_house", "chests/village/village_savanna_house", "chests/village/village_shepherd", "chests/village/village_snowy_house", "chests/village/village_taiga_house", "chests/village/village_temple", "chests/nether_bridge", "chests/desert_pyramid", "chests/abandoned_mineshaft"), new ItemStack(ModItems.STURDY_BEE_CAGE), 0.2f), new ICondition[0]);
        this.add("frog_eat_bee", (IGlobalLootModifier)new IngredientModifier(this.frogConditions("entities/bee"), ComponentIngredient.of(BeeCreator.getSpawnEgg(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"ribbeet"))), 1.0f, true), new ICondition[0]);
        this.add("undergarden_forgotten_egg", (IGlobalLootModifier)new IngredientModifier(this.lootTableConditions(false, "undergarden:chests/catacombs"), ComponentIngredient.of(BeeCreator.getSpawnEgg(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"forgotten"), true)), 0.25f, false), new ICondition[0]);
        this.add("aquaculture_neptunium_egg", (IGlobalLootModifier)new ContainerContentsModifier(this.lootTableConditions(false, BuiltInLootTables.FISHING.location().toString()), new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"aquaculture", (String)"neptunes_bounty"))), ComponentIngredient.of(BeeCreator.getSpawnEgg(ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"neptunium"), true)), 0.25f, false), new ICondition[0]);
    }

    private LootItemCondition[] lootTableConditions(boolean addUUIDCondition, String ... rLoc) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (String s : rLoc) {
            list.add(LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)s)).build());
        }
        if (addUUIDCondition) {
            list.add(new LootItemKilledByUUIDCondition(ModEntities.WANNA_BEE_UUID));
        }
        return list.toArray(new LootItemCondition[0]);
    }

    private LootItemCondition[] anyOfConditions(String ... rLoc) {
        ArrayList<LootTableIdCondition.Builder> list = new ArrayList<LootTableIdCondition.Builder>();
        for (String s : rLoc) {
            list.add(LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)s)));
        }
        return List.of(AnyOfCondition.anyOf((LootItemCondition.Builder[])list.toArray(new LootItemCondition.Builder[0])).build()).toArray(new LootItemCondition[0]);
    }

    private LootItemCondition[] frogConditions(String ... rLoc) {
        ArrayList<LootItemCondition> list = new ArrayList<LootItemCondition>();
        list.add(DamageSourceCondition.hasDamageSource((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.damageType().source(EntityPredicate.Builder.entity().of(EntityType.FROG))).build());
        for (String s : rLoc) {
            list.add(LootTableIdCondition.builder((ResourceLocation)ResourceLocation.parse((String)s)).build());
        }
        return list.toArray(new LootItemCondition[0]);
    }
}

