/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.datagen;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivelib.loot.OptionalLootItem;
import cy.jdkdigital.productivelib.loot.condition.OptionalCopyBlockState;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class BlockLootProvider
implements DataProvider {
    private final PackOutput.PathProvider pathProvider;
    private final List<LootTableProvider.SubProviderEntry> subProviders;
    private final CompletableFuture<HolderLookup.Provider> registries;

    public BlockLootProvider(PackOutput packOutput, List<LootTableProvider.SubProviderEntry> providers, CompletableFuture<HolderLookup.Provider> registries) {
        this.pathProvider = packOutput.createPathProvider(PackOutput.Target.DATA_PACK, "loot_table");
        this.subProviders = providers;
        this.registries = registries;
    }

    public String getName() {
        return "Productive Bees Block Loot Table datagen";
    }

    public CompletableFuture<?> run(CachedOutput pOutput) {
        return this.registries.thenCompose(provider -> this.run(pOutput, (HolderLookup.Provider)provider));
    }

    private CompletableFuture<?> run(CachedOutput pOutput, HolderLookup.Provider pProvider) {
        HashMap map = Maps.newHashMap();
        this.subProviders.forEach(providerEntry -> ((LootTableSubProvider)providerEntry.provider().apply(pProvider)).generate((resourceKey, builder) -> {
            builder.setRandomSequence(resourceKey.location());
            if (map.put(resourceKey.location(), builder.setParamSet(providerEntry.paramSet()).build()) != null) {
                throw new IllegalStateException("Duplicate loot table " + String.valueOf(resourceKey.location()));
            }
        }));
        return CompletableFuture.allOf((CompletableFuture[])map.entrySet().stream().map(entry -> DataProvider.saveStable((CachedOutput)pOutput, (HolderLookup.Provider)pProvider, (Codec)LootTable.DIRECT_CODEC, (Object)((LootTable)entry.getValue()), (Path)this.pathProvider.json((ResourceLocation)entry.getKey()))).toArray(CompletableFuture[]::new));
    }

    public static class LootProvider
    extends BlockLootSubProvider {
        private final Map<Block, Function<Block, LootTable.Builder>> functionTable = new HashMap<Block, Function<Block, LootTable.Builder>>();
        private List<Block> knownBlocks = new ArrayList<Block>();
        static LootItemCondition.Builder HAS_SILK;

        public LootProvider(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected void generate() {
            HashMap tables = new HashMap();
            HAS_SILK = this.hasSilkTouch();
            ModBlocks.HIVELIST.forEach((modid, strings) -> {
                if (ProductiveBees.includeMod(modid)) {
                    strings.forEach((name, type) -> {
                        name = modid.equals("productivebees") ? name : modid + "_" + name;
                        Block hive = (Block)ModBlocks.HIVES.get("advanced_" + name + "_beehive").get();
                        Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + name).get();
                        Function<Block, LootTable.Builder> hiveFunc = this.functionTable.getOrDefault(hive, LootProvider::genHiveDrop);
                        this.add(hive, hiveFunc.apply(hive));
                        Function<Block, LootTable.Builder> expansionFunc = this.functionTable.getOrDefault(box, LootProvider::genExpansionDrop);
                        this.add(box, expansionFunc.apply(box));
                    });
                }
            });
            ModBlocks.hiveStyles.forEach(style -> {
                Block hive = (Block)ModBlocks.HIVES.get("advanced_" + style + "_canvas_beehive").get();
                Block box = (Block)ModBlocks.EXPANSIONS.get("expansion_box_" + style + "_canvas").get();
                Function<Block, LootTable.Builder> hiveFunc = this.functionTable.getOrDefault(hive, LootProvider::genHiveDrop);
                this.add(hive, hiveFunc.apply(hive));
                Function<Block, LootTable.Builder> expansionFunc = this.functionTable.getOrDefault(box, LootProvider::genExpansionDrop);
                this.add(box, expansionFunc.apply(box));
            });
            this.add((Block)ModBlocks.DRAGON_EGG_HIVE.get(), this.functionTable.getOrDefault(ModBlocks.DRAGON_EGG_HIVE.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.DRAGON_EGG_HIVE.get()));
            this.add((Block)ModBlocks.OAK_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.OAK_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.OAK_WOOD_NEST.get()));
            this.add((Block)ModBlocks.SPRUCE_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SPRUCE_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SPRUCE_WOOD_NEST.get()));
            this.add((Block)ModBlocks.DARK_OAK_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.DARK_OAK_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.DARK_OAK_WOOD_NEST.get()));
            this.add((Block)ModBlocks.BIRCH_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.BIRCH_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.BIRCH_WOOD_NEST.get()));
            this.add((Block)ModBlocks.JUNGLE_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.JUNGLE_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.JUNGLE_WOOD_NEST.get()));
            this.add((Block)ModBlocks.ACACIA_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.ACACIA_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.ACACIA_WOOD_NEST.get()));
            this.add((Block)ModBlocks.CHERRY_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.CHERRY_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.CHERRY_WOOD_NEST.get()));
            this.add((Block)ModBlocks.MANGROVE_WOOD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.MANGROVE_WOOD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.MANGROVE_WOOD_NEST.get()));
            this.add((Block)ModBlocks.BAMBOO_HIVE.get(), this.functionTable.getOrDefault(ModBlocks.BAMBOO_HIVE.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.BAMBOO_HIVE.get()));
            this.add((Block)ModBlocks.DRAGON_EGG_HIVE.get(), this.functionTable.getOrDefault(ModBlocks.DRAGON_EGG_HIVE.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.DRAGON_EGG_HIVE.get()));
            this.add((Block)ModBlocks.STONE_NEST.get(), this.functionTable.getOrDefault(ModBlocks.STONE_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.STONE_NEST.get()));
            this.add((Block)ModBlocks.COARSE_DIRT_NEST.get(), this.functionTable.getOrDefault(ModBlocks.COARSE_DIRT_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.COARSE_DIRT_NEST.get()));
            this.add((Block)ModBlocks.SAND_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SAND_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SAND_NEST.get()));
            this.add((Block)ModBlocks.SNOW_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SNOW_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SNOW_NEST.get()));
            this.add((Block)ModBlocks.GRAVEL_NEST.get(), this.functionTable.getOrDefault(ModBlocks.GRAVEL_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.GRAVEL_NEST.get()));
            this.add((Block)ModBlocks.SUGAR_CANE_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SUGAR_CANE_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SUGAR_CANE_NEST.get()));
            this.add((Block)ModBlocks.SLIMY_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SLIMY_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SLIMY_NEST.get()));
            this.add((Block)ModBlocks.GLOWSTONE_NEST.get(), this.functionTable.getOrDefault(ModBlocks.GLOWSTONE_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.GLOWSTONE_NEST.get()));
            this.add((Block)ModBlocks.SOUL_SAND_NEST.get(), this.functionTable.getOrDefault(ModBlocks.SOUL_SAND_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.SOUL_SAND_NEST.get()));
            this.add((Block)ModBlocks.NETHER_QUARTZ_NEST.get(), this.functionTable.getOrDefault(ModBlocks.NETHER_QUARTZ_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.NETHER_QUARTZ_NEST.get()));
            this.add((Block)ModBlocks.NETHER_GOLD_NEST.get(), this.functionTable.getOrDefault(ModBlocks.NETHER_GOLD_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.NETHER_GOLD_NEST.get()));
            this.add((Block)ModBlocks.NETHER_BRICK_NEST.get(), this.functionTable.getOrDefault(ModBlocks.NETHER_BRICK_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.NETHER_BRICK_NEST.get()));
            this.add((Block)ModBlocks.END_NEST.get(), this.functionTable.getOrDefault(ModBlocks.END_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.END_NEST.get()));
            this.add((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get(), this.functionTable.getOrDefault(ModBlocks.OBSIDIAN_PILLAR_NEST.get(), LootProvider::genHiveDrop).apply((Block)ModBlocks.OBSIDIAN_PILLAR_NEST.get()));
            this.add((Block)ModBlocks.AMBER.get(), this.functionTable.getOrDefault(ModBlocks.AMBER.get(), LootProvider::amberDrop).apply((Block)ModBlocks.AMBER.get()));
            Function<Block, LootTable.Builder> func = this.functionTable.getOrDefault(ModBlocks.PETRIFIED_HONEY.get(), this::genBlockDrop);
            this.add((Block)ModBlocks.PETRIFIED_HONEY.get(), func.apply((Block)ModBlocks.PETRIFIED_HONEY.get()));
            ModBlocks.PETRIFIED_HONEY_BLOCKS.forEach(registryObject -> {
                Function<Block, LootTable.Builder> petrifiedFunc = this.functionTable.getOrDefault(registryObject.get(), this::genBlockDrop);
                this.add((Block)registryObject.get(), petrifiedFunc.apply((Block)registryObject.get()));
            });
        }

        protected void add(Block block, LootTable.Builder builder) {
            super.add(block, builder);
            this.knownBlocks.add(block);
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.knownBlocks;
        }

        public static LootTable.Builder genHiveDrop(Block hive) {
            LootPoolSingletonContainer.Builder hiveNoHoney = ((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)hive).when(ExplosionCondition.survivesExplosion())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES));
            LootPoolSingletonContainer.Builder hiveHoney = hive.defaultBlockState().hasProperty((Property)BeehiveBlock.HONEY_LEVEL) ? ((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)hive).when(HAS_SILK)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES)).apply((LootItemFunction.Builder)OptionalCopyBlockState.copyState((Block)hive).copy((Property)BeehiveBlock.HONEY_LEVEL)) : ((LootPoolSingletonContainer.Builder)OptionalLootItem.lootTableItem((ItemLike)hive).when(HAS_SILK)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.BEES));
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)hiveHoney.otherwise((LootPoolEntryContainer.Builder)hiveNoHoney)));
        }

        public static LootTable.Builder amberDrop(Block hive) {
            LootPoolSingletonContainer.Builder hiveNoHoney = ((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)hive).when(ExplosionCondition.survivesExplosion())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(DataComponents.ENTITY_DATA));
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)hiveNoHoney));
        }

        public static LootTable.Builder genExpansionDrop(Block expansion) {
            LootPoolEntryContainer.Builder expansionBox = OptionalLootItem.lootTableItem((ItemLike)expansion).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(expansionBox));
        }

        public LootTable.Builder genBlockDrop(Block expansion) {
            LootPoolEntryContainer.Builder builder = LootItem.lootTableItem((ItemLike)expansion).when(ExplosionCondition.survivesExplosion());
            return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(builder));
        }
    }
}

