/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.container.CryoStasisContainer;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class CryoStasisScreen
extends AbstractContainerScreen<CryoStasisContainer> {
    int scrollOff;
    private EditBox searchBox;
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/cryo_stasis.png");

    public CryoStasisScreen(CryoStasisContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
        this.imageWidth = 276;
    }

    protected void init() {
        super.init();
        this.searchBox = new EditBox(this.font, this.leftPos + 10, this.topPos + 147, 85, 16, (Component)Component.translatable((String)"itemGroup.search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(false);
        this.searchBox.setTextColor(0xFFFFFF);
        this.searchBox.setCanLoseFocus(false);
        this.searchBox.setFocused(true);
        this.addWidget((GuiEventListener)this.searchBox);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.shouldCloseOnEsc() || this.getFocused() != null && !this.getFocused().isFocused()) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        return false;
    }

    protected void containerTick() {
        super.containerTick();
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        int k = j + 16 + 1;
        int l = i + 5 + 5;
        this.renderScroller(guiGraphics, i, j, 2);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 107, this.getYSize() - 94, 0x404040, false);
        ArrayList tooltipList = new ArrayList();
        guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, i, j, 0, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        this.searchBox.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(GuiGraphics guiGraphics, int offsetX, int offsetY, int items) {
        int i = items + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int i1 = Math.min(113, this.scrollOff * k);
            if (this.scrollOff == i - 1) {
                i1 = 113;
            }
            guiGraphics.blit(GUI_TEXTURE, offsetX + 94, offsetY + 18 + i1, 0, 0.0f, 166.0f, 6, 27, 512, 256);
        } else {
            guiGraphics.blit(GUI_TEXTURE, offsetX + 94, offsetY + 18, 0, 6.0f, 166.0f, 6, 27, 512, 256);
        }
    }
}

