/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.container.BreedingChamberContainer;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;

public class BreedingChamberScreen
extends AbstractContainerScreen<BreedingChamberContainer> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/breeding_chamber.png");

    public BreedingChamberScreen(BreedingChamberContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        super.render(matrixStack, mouseX, mouseY, partialTicks);
        this.renderTooltip(matrixStack, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, -5, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, -5, this.getYSize() - 96 + 2, 0x404040, false);
        ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
        int energyAmount = ((BreedingChamberContainer)this.menu).blockEntity.energyHandler.getEnergyStored();
        if (this.isHovering(-5, 16, 6, 54, mouseX, mouseY)) {
            tooltipList.add(Component.translatable((String)"productivebees.screen.energy_level", (Object[])new Object[]{energyAmount + "FE"}).getVisualOrderText());
        }
        if (((BreedingChamberContainer)this.menu).blockEntity.chosenRecipe != null && this.minecraft != null) {
            BeeIngredient beeIngredient = ((BeeBreedingRecipe)((BreedingChamberContainer)this.menu).blockEntity.chosenRecipe.value()).offspring.get();
            Entity bee = null;
            if (beeIngredient != null) {
                bee = beeIngredient.getCachedEntity((Level)this.minecraft.level);
            }
            if (bee != null && this.isHovering(121, 17, 16, 16, mouseX, mouseY)) {
                tooltipList.add(bee.getName().getVisualOrderText());
            }
        }
        if (this.isHovering(146, 14, 10, 10, mouseX, mouseY)) {
            tooltipList.add(Component.translatable((String)"productivebees.breeding_chamber.tooltip.next_bee").getVisualOrderText());
        }
        if (this.isHovering(72, 14, 18, 18, mouseX, mouseY) && ((BreedingChamberContainer)this.menu).blockEntity.inventoryHandler.getStackInSlot(0).isEmpty()) {
            tooltipList.add(Component.translatable((String)"productivebees.breeding_chamber.tooltip.cage").getVisualOrderText());
        }
        guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
    }

    protected void renderBg(@Nonnull GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 13, this.getGuiTop(), 0, 0, this.getXSize() + 26, this.getYSize());
        int progress = (int)((float)((BreedingChamberContainer)this.menu).blockEntity.getRecipeProgress() * (45.0f / (float)((BreedingChamberContainer)this.menu).blockEntity.getProcessingTime(((BreedingChamberContainer)this.menu).blockEntity.chosenRecipe)));
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() + 85 - 13, this.getGuiTop() + 14, 202, 52, progress + 1, 22);
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 5, this.getGuiTop() + 17, 206, 0, 4, 52);
        int energyAmount = ((BreedingChamberContainer)this.menu).blockEntity.energyHandler.getEnergyStored();
        int energyLevel = (int)((float)energyAmount * 0.0052f);
        guiGraphics.blit(GUI_TEXTURE, this.getGuiLeft() - 5, this.getGuiTop() + 17, 8, 17, 4, 52 - energyLevel);
        if (this.minecraft != null) {
            if (((BreedingChamberContainer)this.menu).blockEntity.chosenRecipe != null) {
                BeeIngredient beeIngredient = ((BeeBreedingRecipe)((BreedingChamberContainer)this.menu).blockEntity.chosenRecipe.value()).offspring.get();
                if (beeIngredient != null) {
                    BeeRenderer.render(guiGraphics, this.getGuiLeft() + 134 - 13, this.getGuiTop() + 17, beeIngredient, this.minecraft);
                }
            } else {
                ItemStack cage1 = ((BreedingChamberContainer)this.menu).blockEntity.inventoryHandler.getStackInSlot(1);
                ItemStack cage2 = ((BreedingChamberContainer)this.menu).blockEntity.inventoryHandler.getStackInSlot(2);
                if (BeeCage.isFilled(cage1) && BeeCage.isFilled(cage2)) {
                    ProductiveBee pBee;
                    Entity entity;
                    CompoundTag tag1 = ((CustomData)cage1.get(DataComponents.CUSTOM_DATA)).copyTag();
                    CompoundTag tag2 = ((CustomData)cage2.get(DataComponents.CUSTOM_DATA)).copyTag();
                    Supplier<BeeIngredient> beeIngredient = BeeIngredientFactory.getIngredient(tag1.contains("type") ? tag1.getString("type") : tag1.getString("entity"));
                    if (tag1.getString("name").equals(tag2.getString("name")) && (!tag1.getBoolean("isProductiveBee") || beeIngredient.get() != null && (entity = beeIngredient.get().getCachedEntity(((BreedingChamberContainer)this.menu).blockEntity.getLevel())) instanceof ProductiveBee && (pBee = (ProductiveBee)entity).canSelfBreed()) && beeIngredient.get() != null) {
                        BeeRenderer.render(guiGraphics, this.getGuiLeft() + 134 - 13, this.getGuiTop() + 17, beeIngredient.get(), this.minecraft);
                    }
                }
            }
        }
    }
}

