/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.container.gui;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.client.render.ingredient.BeeRenderer;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.DragonEggHiveBlockEntity;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;

public class AdvancedBeehiveScreen
extends AbstractContainerScreen<AdvancedBeehiveContainer> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/advanced_beehive.png");
    private static final ResourceLocation GUI_TEXTURE_EXPANDED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/advanced_beehive_expanded.png");
    private static final ResourceLocation GUI_TEXTURE_SIMULATED = ResourceLocation.fromNamespaceAndPath((String)"productivebees", (String)"textures/gui/container/advanced_beehive_simulated.png");

    public AdvancedBeehiveScreen(AdvancedBeehiveContainer screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
    }

    public void render(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        boolean expanded = ((AdvancedBeehiveContainer)this.menu).blockEntity.getBlockState().getValue(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        boolean simulated = expanded && ((AdvancedBeehiveContainer)this.menu).blockEntity.isSim();
        guiGraphics.drawString(this.font, this.title, expanded ? -5 : 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, expanded ? -5 : 8, this.getYSize() - 96 + 2, 0x404040, false);
        assert (this.minecraft != null);
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        ArrayList<FormattedCharSequence> tooltipList = new ArrayList<FormattedCharSequence>();
        if (simulated && this.isHovering(73, 53, 16, 16, mouseX, mouseY) && ((AdvancedBeehiveContainer)this.menu).blockEntity.inventoryHandler.getStackInSlot(11).isEmpty()) {
            tooltipList.add(Component.translatable((String)"productivebees.advanced_hive.tooltip.bee_cage").getVisualOrderText());
        }
        int j = 0;
        for (BeehiveBlockEntity.BeeData inhabitant : ((AdvancedBeehiveContainer)this.menu).blockEntity.stored) {
            BeeIngredient beeIngredient;
            CompoundTag occupant = inhabitant.occupant.entityData().copyTag();
            Entity bee = null;
            String type = occupant.getString("type");
            if (type.isEmpty()) {
                type = occupant.getString("id");
            }
            if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) != null) {
                bee = beeIngredient.getCachedEntity((Level)this.minecraft.level);
            } else {
                ProductiveBees.LOGGER.info("try render bee tooltip " + String.valueOf(beeIngredient) + " " + type + " " + this.isHovering(positions.get(j).get(0) - (expanded ? 13 : 0), positions.get(j).get(1), 16, 16, mouseX, mouseY) + " " + String.valueOf(bee));
            }
            if (bee != null && bee.getEncodeId() != null) {
                if (bee instanceof ConfigurableBee && occupant.contains("type")) {
                    ((ConfigurableBee)bee).setBeeType(occupant.getString("type"));
                }
                if (positions.containsKey(j) && this.isHovering(positions.get(j).get(0) - (expanded ? 13 : 0), positions.get(j).get(1), 16, 16, mouseX, mouseY)) {
                    CompoundTag tag = occupant.copy();
                    tooltipList.add(bee.getName().getVisualOrderText());
                    if (Screen.hasShiftDown()) {
                        String modId = ResourceLocation.parse((String)bee.getEncodeId()).getNamespace();
                        if (modId.equals("productivebees")) {
                            tag.putBoolean("isProductiveBee", true);
                        }
                        String modName = ((ModContainer)ModList.get().getModContainerById(modId).get()).getClass().getSimpleName();
                        if (modId.equals("minecraft")) {
                            modName = "Minecraft";
                        }
                        tag.putString("mod", modName);
                        List<Component> list = BeeHelper.populateBeeInfoFromTag(tag, null);
                        for (Component textComponent : list) {
                            tooltipList.add(textComponent.getVisualOrderText());
                        }
                    } else {
                        tooltipList.add(Component.translatable((String)"productivebees.information.hold_shift").withStyle(ChatFormatting.WHITE).getVisualOrderText());
                    }
                }
            }
            ++j;
        }
        guiGraphics.renderTooltip(this.font, tooltipList, mouseX - this.getGuiLeft(), mouseY - this.getGuiTop());
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        boolean simulated;
        boolean expanded = ((AdvancedBeehiveContainer)this.menu).blockEntity.getBlockState().getValue(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
        boolean bl = simulated = expanded && ((AdvancedBeehiveContainer)this.menu).blockEntity.isSim();
        ResourceLocation GUI = expanded ? (simulated ? GUI_TEXTURE_SIMULATED : GUI_TEXTURE_EXPANDED) : GUI_TEXTURE;
        int honeyLevel = (Integer)((AdvancedBeehiveContainer)this.menu).blockEntity.getBlockState().getValue((Property)BeehiveBlock.HONEY_LEVEL);
        guiGraphics.blit(GUI, this.getGuiLeft() - (expanded ? 13 : 0), this.getGuiTop(), 0, 0, this.getXSize() + (expanded ? 26 : 0), this.getYSize());
        HashMap<Integer, List<Integer>> positions = expanded ? AdvancedBeehiveContainer.BEE_POSITIONS_EXPANDED : AdvancedBeehiveContainer.BEE_POSITIONS;
        int xOffset = ((AdvancedBeehiveContainer)this.menu).blockEntity instanceof DragonEggHiveBlockEntity ? 13 : 0;
        guiGraphics.blit(GUI, this.getGuiLeft() + 87 - (expanded ? 13 : 0), this.getGuiTop() + 37, 202 + xOffset, honeyLevel * 13, 13, 13);
        if (simulated && ((AdvancedBeehiveContainer)this.menu).blockEntity.inventoryHandler.getStackInSlot(11).isEmpty()) {
            guiGraphics.blit(GUI, this.getGuiLeft() + 87 - 13, this.getGuiTop() + 53, 202 + xOffset, 78, 14, 16);
        }
        int i = 0;
        for (BeehiveBlockEntity.BeeData inhabitant : ((AdvancedBeehiveContainer)this.menu).blockEntity.stored) {
            CompoundTag occupant = inhabitant.occupant.entityData().copyTag();
            if (this.minecraft != null && positions.containsKey(i)) {
                BeeIngredient beeIngredient;
                String type = occupant.getString("type");
                if (type.isEmpty() || type.equals("minecraft:")) {
                    type = occupant.getString("id");
                }
                if ((beeIngredient = BeeIngredientFactory.getIngredient(type).get()) == null) {
                    ProductiveBees.LOGGER.info("render bee in hive " + String.valueOf(positions.get(i)) + " " + type + " " + String.valueOf(occupant));
                }
                if (beeIngredient != null) {
                    BeeRenderer.render(guiGraphics, this.getGuiLeft() + positions.get(i).get(0) - (expanded ? 13 : 0), this.getGuiTop() + positions.get(i).get(1), beeIngredient, this.minecraft);
                }
            }
            ++i;
        }
    }
}

