/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.init.ModRecipeTypes;
import cy.jdkdigital.productivebees.util.BeeHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.Lazy;

public class BeeBreedingRecipe
implements Recipe<RecipeInput>,
TimedRecipeInterface {
    public final Supplier<BeeIngredient> parent1;
    public final Supplier<BeeIngredient> parent2;
    public final Supplier<BeeIngredient> offspring;

    public BeeBreedingRecipe(Supplier<BeeIngredient> parent1, Supplier<BeeIngredient> parent2, Supplier<BeeIngredient> offspring) {
        this.parent1 = parent1;
        this.parent2 = parent2;
        this.offspring = offspring;
    }

    @Override
    public int getProcessingTime() {
        return (Integer)ProductiveBeesConfig.GENERAL.breedingChamberProcessingTime.get();
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        if (inv instanceof BeeHelper.IdentifierInventory) {
            String beeName1 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(0);
            String beeName2 = ((BeeHelper.IdentifierInventory)inv).getIdentifier(1);
            for (Supplier<BeeIngredient> parent : List.of(this.parent1, this.parent2)) {
                if (parent.get() != null) {
                    String parentName = parent.get().getBeeType().toString();
                    if (parentName.equals(beeName1) || parentName.equals(beeName2)) continue;
                    return false;
                }
                ProductiveBees.LOGGER.warn("Bee not found in breeding recipe");
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isSpecial() {
        return true;
    }

    @Nonnull
    public ItemStack assemble(RecipeInput inv, HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    @Nonnull
    public ItemStack getResultItem(HolderLookup.Provider pRegistries) {
        return ItemStack.EMPTY;
    }

    @Nonnull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeTypes.BEE_BREEDING.get();
    }

    @Nonnull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipeTypes.BEE_BREEDING_TYPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BeeBreedingRecipe> {
        private static final MapCodec<BeeBreedingRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)BeeIngredient.CODEC.fieldOf("parent1").forGetter(recipe -> recipe.parent1), (App)BeeIngredient.CODEC.fieldOf("parent2").forGetter(recipe -> recipe.parent2), (App)BeeIngredient.CODEC.fieldOf("offspring").forGetter(recipe -> recipe.offspring)).apply((Applicative)builder, BeeBreedingRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, BeeBreedingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<BeeBreedingRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, BeeBreedingRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        public static BeeBreedingRecipe fromNetwork(@Nonnull RegistryFriendlyByteBuf buffer) {
            try {
                BeeIngredient ing1 = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                BeeIngredient ing2 = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                BeeIngredient offspring = BeeIngredient.fromNetwork((FriendlyByteBuf)buffer);
                return new BeeBreedingRecipe((Supplier<BeeIngredient>)Lazy.of(() -> ing1), (Supplier<BeeIngredient>)Lazy.of(() -> ing2), (Supplier<BeeIngredient>)Lazy.of(() -> offspring));
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error reading bee breeding recipe from packet. ", (Throwable)e);
                throw e;
            }
        }

        public static void toNetwork(@Nonnull RegistryFriendlyByteBuf buffer, BeeBreedingRecipe recipe) {
            try {
                recipe.parent1.get().toNetwork((FriendlyByteBuf)buffer);
                recipe.parent2.get().toNetwork((FriendlyByteBuf)buffer);
                recipe.offspring.get().toNetwork((FriendlyByteBuf)buffer);
            }
            catch (Exception e) {
                ProductiveBees.LOGGER.error("Error writing bee breeding recipe to packet. ", (Throwable)e);
                throw e;
            }
        }
    }
}

