/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.item;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.client.model.BeeNestHelmetModel;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class BeeNestHelmet
extends ArmorItem {
    public BeeNestHelmet(Holder<ArmorMaterial> pMaterial, Item.Properties pProperties) {
        super(pMaterial, ArmorItem.Type.HELMET, pProperties);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTooltipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTooltipComponents, pTooltipFlag);
        pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.bee_helmet.info1").withStyle(ChatFormatting.DARK_PURPLE));
        pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.bee_helmet.info2").withStyle(ChatFormatting.LIGHT_PURPLE));
        pTooltipComponents.add((Component)Component.translatable((String)"productivebees.information.bee_helmet.info3", (Object[])new Object[]{100.0 * (Double)ProductiveBeesConfig.BEES.kamikazBeeChance.get()}).withStyle(ChatFormatting.LIGHT_PURPLE));
    }

    public void inventoryTick(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (pLevel.isClientSide() && pSlotId >= 36 && pSlotId <= 39) {
            BlockPos pos = pEntity.blockPosition();
            if (pLevel.getRandom().nextDouble() < 0.005 && !((Boolean)ProductiveBeesConfig.CLIENT.mutedBeeNestHelmet.get()).booleanValue() && pEntity instanceof Player) {
                Player player = (Player)pEntity;
                pLevel.playSound(player, (double)pos.getX(), (double)pos.getY() + 2.0, (double)pos.getZ(), pLevel.random.nextBoolean() ? SoundEvents.BEEHIVE_WORK : SoundEvents.BEEHIVE_DRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (pLevel.getRandom().nextDouble() < 0.015) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.FALLING_NECTAR, Mth.lerp((double)pLevel.random.nextDouble(), (double)((double)pos.getX() - 0.5), (double)((double)pos.getX() + 0.5)), (double)pos.getY() + 1.8, Mth.lerp((double)pLevel.random.nextDouble(), (double)((double)pos.getZ() - 0.5), (double)((double)pos.getZ() + 0.5)), 0.0, 0.0, 0.0);
            }
        }
        super.inventoryTick(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(this){

            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return (HumanoidModel)BeeNestHelmetModel.INSTANCE.get();
            }
        });
    }
}

