/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class JarBlockEntity
extends AbstractBlockEntity {
    @Nullable
    private Entity cachedEntity;
    public int tickCount = 0;
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 1, (BlockEntity)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.getItem().asItem() instanceof BeeCage && BeeCage.isFilled(stack);
        }

        public boolean isContainerItem(Item item) {
            return item instanceof BeeCage;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Level level = this.blockEntity.getLevel();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendBlockUpdated(this.blockEntity.getBlockPos(), this.blockEntity.getBlockState(), this.blockEntity.getBlockState(), 3);
            }
        }
    };

    public JarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.JAR.get(), pos, state);
    }

    @Nullable
    public Entity getCachedEntity(ItemStack cage) {
        if (this.cachedEntity == null) {
            this.cachedEntity = BeeCage.getEntityFromStack(cage, this.getLevel(), false);
        }
        return this.cachedEntity;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        IItemHandlerModifiable iItemHandlerModifiable = this.inventoryHandler;
        if (iItemHandlerModifiable instanceof ItemStackHandler) {
            ItemStackHandler serializable = (ItemStackHandler)iItemHandlerModifiable;
            tag.put("inv", (Tag)serializable.serializeNBT(provider));
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        CompoundTag invTag = tag.getCompound("inv");
        IItemHandlerModifiable iItemHandlerModifiable = this.inventoryHandler;
        if (iItemHandlerModifiable instanceof ItemStackHandler) {
            ItemStackHandler serializable = (ItemStackHandler)iItemHandlerModifiable;
            serializable.deserializeNBT(provider, invTag);
        }
        this.tickCount = ProductiveBees.random.nextInt(360);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        super.applyImplicitComponents(pComponentInput);
        CompoundTag d = ((CustomData)pComponentInput.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (this.level != null) {
            this.loadPacketNBT(d, (HolderLookup.Provider)this.level.registryAccess());
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        super.collectImplicitComponents(pComponents);
        IItemHandlerModifiable iItemHandlerModifiable = this.inventoryHandler;
        if (iItemHandlerModifiable instanceof ItemStackHandler) {
            ItemStackHandler serializable = (ItemStackHandler)iItemHandlerModifiable;
            if (this.level != null) {
                pComponents.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)serializable.serializeNBT((HolderLookup.Provider)this.level.registryAccess())));
            }
        }
    }
}

