/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.PoweredCentrifugeBlockEntity;
import cy.jdkdigital.productivebees.common.item.CombBlockItem;
import cy.jdkdigital.productivebees.common.recipe.CentrifugeRecipe;
import cy.jdkdigital.productivebees.container.HeatedCentrifugeContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class HeatedCentrifugeBlockEntity
extends PoweredCentrifugeBlockEntity {
    static Map<String, RecipeHolder<CentrifugeRecipe>> blockRecipeMap = new HashMap<String, RecipeHolder<CentrifugeRecipe>>();

    public HeatedCentrifugeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.HEATED_CENTRIFUGE.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, HeatedCentrifugeBlockEntity blockEntity) {
        PoweredCentrifugeBlockEntity.tick(level, pos, state, blockEntity);
    }

    @Override
    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = 1.0 + (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(1.0, timeUpgradeModifier) * 3.0;
    }

    @Override
    protected double getProcessingTimeModifier() {
        return super.getProcessingTimeModifier() / 3.0;
    }

    @Override
    protected boolean canOperate() {
        int energy = this.energyHandler.getEnergyStored();
        return energy >= (Integer)ProductiveBeesConfig.GENERAL.centrifugePowerUse.get();
    }

    @Override
    public boolean canProcessItemStack(ItemStack stack) {
        boolean directProcess = super.canProcessItemStack(stack);
        if (stack.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS) && !directProcess) {
            ItemStack singleComb;
            if (stack.getItem() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                singleComb.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)stack.get(ModDataComponents.BEE_TYPE)));
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.level, stack.getItem());
            }
            return !singleComb.isEmpty() && super.canProcessItemStack(singleComb);
        }
        return directProcess;
    }

    @Override
    protected RecipeHolder<CentrifugeRecipe> getRecipe(InventoryHandlerHelper.BlockEntityItemStackHandler inputHandler) {
        RecipeHolder<CentrifugeRecipe> directRecipe;
        if (blockRecipeMap.size() > 5000) {
            blockRecipeMap.clear();
        }
        ItemStack input = inputHandler.getStackInSlot(1);
        String cacheKey = BuiltInRegistries.ITEM.getKey((Object)input.getItem()).toString() + String.valueOf(!input.getComponents().isEmpty() ? input.getComponents().stream().map(TypedDataComponent::toString).reduce((s, s2) -> s + s2) : "");
        if (!input.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS) && (directRecipe = super.getRecipe(inputHandler)) != null) {
            return directRecipe;
        }
        if (!blockRecipeMap.containsKey(cacheKey)) {
            ItemStack singleComb;
            if (input.getItem() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get());
                singleComb.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)input.get(ModDataComponents.BEE_TYPE)));
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.level, input.getItem());
            }
            InventoryHandlerHelper.BlockEntityItemStackHandler inv = new InventoryHandlerHelper.BlockEntityItemStackHandler(2);
            inv.setStackInSlot(1, singleComb);
            blockRecipeMap.put(cacheKey, super.getRecipe(inv));
        }
        return blockRecipeMap.get(cacheKey);
    }

    @Override
    protected void completeRecipeProcessing(RecipeHolder<CentrifugeRecipe> recipe, IItemHandlerModifiable invHandler, RandomSource random) {
        ItemStack input = invHandler.getStackInSlot(1).copy();
        if (input.is(ModTags.Common.STORAGE_BLOCK_HONEYCOMBS) && !((CentrifugeRecipe)recipe.value()).ingredient.test(input)) {
            ItemStack singleComb;
            if (input.getItem() instanceof CombBlockItem) {
                singleComb = new ItemStack((ItemLike)ModItems.CONFIGURABLE_HONEYCOMB.get(), 4);
                singleComb.set(ModDataComponents.BEE_TYPE, (Object)((ResourceLocation)input.get(ModDataComponents.BEE_TYPE)));
            } else {
                singleComb = BeeHelper.getRecipeOutputFromInput(this.level, input.getItem());
            }
            invHandler.setStackInSlot(1, singleComb);
            for (int i = 0; i < 4; ++i) {
                super.completeRecipeProcessing(recipe, invHandler, random, true);
            }
            input.shrink(1);
            invHandler.setStackInSlot(1, input);
        } else {
            super.completeRecipeProcessing(recipe, invHandler, random, true);
        }
    }

    @Override
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.HEATED_CENTRIFUGE.get()).getDescriptionId());
    }

    @Override
    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new HeatedCentrifugeContainer(pContainerId, pPlayerInventory, this);
    }

    @Override
    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    @Override
    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }

    @Override
    public FluidTank getFluidHandler() {
        return this.fluidHandler;
    }
}

