/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.common.recipe.CombineGeneRecipe;
import cy.jdkdigital.productivebees.container.GeneIndexerContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class GeneIndexerBlockEntity
extends CapabilityBlockEntity
implements MenuProvider {
    private int tickCounter = 0;
    private boolean needsReindexing = true;
    private boolean isRunning = true;
    private final Map<String, Map<Integer, Integer>> index = new HashMap<String, Map<Integer, Integer>>();
    public final IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 104, (BlockEntity)this){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack, boolean fromAutomation) {
            return stack.getItem() instanceof Gene;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BlockEntity blockEntity = this.blockEntity;
            if (blockEntity instanceof GeneIndexerBlockEntity) {
                GeneIndexerBlockEntity geneIndexerBlockEntity = (GeneIndexerBlockEntity)blockEntity;
                geneIndexerBlockEntity.setDirty();
            }
        }

        public int[] getOutputSlots() {
            return IntStream.range(0, this.getSlots()).toArray();
        }

        public boolean isInsertableSlot(int slot) {
            return true;
        }

        public boolean isInputSlot(int slot) {
            return false;
        }

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return this.isItemValid(slot, item);
        }
    };

    public GeneIndexerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.GENE_INDEXER.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, GeneIndexerBlockEntity blockEntity) {
        if (level != null && !level.isClientSide) {
            if (blockEntity.needsReindexing && !blockEntity.isRunning) {
                GeneIndexerBlockEntity.buildIndex(blockEntity, state);
            }
            if (--blockEntity.tickCounter <= 0) {
                blockEntity.tickCounter = 2;
                if (blockEntity.isRunning && blockEntity.index.size() > 0) {
                    if (!((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
                        blockEntity.isRunning = false;
                        return;
                    }
                    Iterator<Map.Entry<String, Map<Integer, Integer>>> indexIterator = blockEntity.index.entrySet().iterator();
                    if (indexIterator.hasNext()) {
                        Map.Entry<String, Map<Integer, Integer>> first = indexIterator.next();
                        if (first.getValue().size() > 1) {
                            Supplier<Stream> sorted = () -> ((Map)first.getValue()).entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue()));
                            Optional firstEntry = sorted.get().findFirst();
                            Optional otherEntry = sorted.get().reduce((entry1, entry2) -> entry2);
                            if (firstEntry.isPresent() && otherEntry.isPresent()) {
                                ItemStack firstStack = blockEntity.inventoryHandler.getStackInSlot(((Integer)((Map.Entry)firstEntry.get()).getKey()).intValue());
                                ItemStack secondStack = blockEntity.inventoryHandler.getStackInSlot(((Integer)((Map.Entry)otherEntry.get()).getKey()).intValue());
                                ItemStack combinedGene = CombineGeneRecipe.mergeGenes(Arrays.asList(firstStack, secondStack));
                                if (!(firstStack.isEmpty() || secondStack.isEmpty() || combinedGene.isEmpty())) {
                                    if (blockEntity.inventoryHandler instanceof InventoryHandlerHelper.BlockEntityItemStackHandler && ((InventoryHandlerHelper.BlockEntityItemStackHandler)blockEntity.inventoryHandler).addOutput(combinedGene).getCount() == 0) {
                                        firstStack.setCount(firstStack.getCount() - 1);
                                        secondStack.setCount(secondStack.getCount() - 1);
                                        blockEntity.inventoryHandler.setStackInSlot(((Integer)((Map.Entry)firstEntry.get()).getKey()).intValue(), firstStack);
                                        blockEntity.inventoryHandler.setStackInSlot(((Integer)((Map.Entry)otherEntry.get()).getKey()).intValue(), secondStack);
                                        if (Gene.getPurity(combinedGene) == 100) {
                                            indexIterator.remove();
                                        }
                                    }
                                } else {
                                    indexIterator.remove();
                                }
                            }
                        } else if (first.getValue().size() == 1) {
                            Map.Entry<Integer, Integer> innerEntry = first.getValue().entrySet().iterator().next();
                            ItemStack stack = blockEntity.inventoryHandler.getStackInSlot(innerEntry.getKey().intValue());
                            if (stack.getCount() == 1) {
                                indexIterator.remove();
                            } else if (stack.getCount() > 1) {
                                ItemStack combinedGene = CombineGeneRecipe.mergeGenes(Arrays.asList(stack, stack.copy()));
                                if (!stack.isEmpty() && !combinedGene.isEmpty() && blockEntity.inventoryHandler instanceof InventoryHandlerHelper.BlockEntityItemStackHandler && ((InventoryHandlerHelper.BlockEntityItemStackHandler)blockEntity.inventoryHandler).addOutput(combinedGene).getCount() == 0) {
                                    stack.setCount(stack.getCount() - 2);
                                    blockEntity.inventoryHandler.setStackInSlot(innerEntry.getKey().intValue(), stack);
                                    if (Gene.getPurity(combinedGene) == 100) {
                                        indexIterator.remove();
                                    }
                                }
                            } else {
                                indexIterator.remove();
                            }
                        } else {
                            indexIterator.remove();
                        }
                    }
                } else {
                    blockEntity.isRunning = false;
                }
            }
        }
    }

    private static void buildIndex(GeneIndexerBlockEntity blockEntity, BlockState state) {
        blockEntity.index.clear();
        for (int slot = 0; slot < blockEntity.inventoryHandler.getSlots(); ++slot) {
            int purity;
            ItemStack stack = blockEntity.inventoryHandler.getStackInSlot(slot);
            if (!stack.getItem().equals(ModItems.GENE.get()) || (purity = Gene.getPurity(stack).intValue()) >= 100) continue;
            String key = String.valueOf((Object)Gene.getAttribute(stack)) + "-" + Gene.getValue(stack);
            if (!blockEntity.index.containsKey(key)) {
                blockEntity.index.put(key, new HashMap());
            }
            Map<Integer, Integer> internalMap = blockEntity.index.get(key);
            internalMap.put(slot, purity);
        }
        if (((Boolean)state.getValue((Property)BlockStateProperties.ENABLED)).booleanValue()) {
            blockEntity.isRunning = true;
        }
        blockEntity.needsReindexing = false;
    }

    public void setDirty() {
        this.needsReindexing = true;
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.GENE_INDEXER.get()).getDescriptionId());
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)((Block)ModBlocks.GENE_INDEXER.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new GeneIndexerContainer(pContainerId, pPlayerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }
}

