/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivelib.common.block.entity.AbstractBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class CombBlockBlockEntity
extends AbstractBlockEntity {
    private ResourceLocation type;

    public CombBlockBlockEntity(BlockPos pos, BlockState state) {
        this(null, pos, state);
    }

    public CombBlockBlockEntity(ResourceLocation type, BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.COMB_BLOCK.get(), pos, state);
        this.type = type;
    }

    public void setType(ResourceLocation type) {
        this.type = type;
    }

    public ResourceLocation getCombType() {
        return this.type;
    }

    public int getColor() {
        CompoundTag nbt;
        if (this.type != null && (nbt = BeeReloadListener.INSTANCE.getData(this.type)) != null) {
            return nbt.getInt("primaryColor");
        }
        return 0;
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.type != null) {
            tag.putString("type", this.type.toString());
        }
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadPacketNBT(tag, provider);
        if (tag.contains("type")) {
            this.setType(ResourceLocation.parse((String)tag.getString("type")));
        }
    }
}

