/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.common.block.entity.IRecipeProcessingBlockEntity;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredient;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.recipe.BeeBreedingRecipe;
import cy.jdkdigital.productivebees.common.recipe.TimedRecipeInterface;
import cy.jdkdigital.productivebees.container.BreedingChamberContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModBlocks;
import cy.jdkdigital.productivebees.init.ModTags;
import cy.jdkdigital.productivebees.setup.BeeReloadListener;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivelib.common.block.entity.CapabilityBlockEntity;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class BreedingChamberBlockEntity
extends CapabilityBlockEntity
implements MenuProvider,
UpgradeableBlockEntity,
IRecipeProcessingBlockEntity {
    public int recipeProgress = 0;
    public int recipeLookupCooldown = 0;
    public boolean isRunning = false;
    private List<RecipeHolder<BeeBreedingRecipe>> currentBreedingRecipes = new ArrayList<RecipeHolder<BeeBreedingRecipe>>();
    public RecipeHolder<BeeBreedingRecipe> chosenRecipe;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 6, (BlockEntity)this){

        public boolean isInputSlotItem(int slot, ItemStack item) {
            return slot != 5 && (slot == 3 || slot == 4) && !(item.getItem() instanceof BeeCage) || slot == 0 && item.getItem() instanceof BeeCage && !BeeCage.isFilled(item) || (slot == 1 || slot == 2) && item.getItem() instanceof BeeCage && BeeCage.isFilled(item);
        }

        public boolean isInputSlot(int slot) {
            return slot != 5;
        }

        public int[] getOutputSlots() {
            return new int[]{5};
        }

        protected void onContentsChanged(int slot) {
            BlockEntity blockEntity;
            super.onContentsChanged(slot);
            if ((slot == 1 || slot == 2) && (blockEntity = this.blockEntity) instanceof BreedingChamberBlockEntity) {
                BreedingChamberBlockEntity breedingChamberBlockEntity = (BreedingChamberBlockEntity)blockEntity;
                breedingChamberBlockEntity.reset();
                breedingChamberBlockEntity.setRecipe(null);
            }
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get()));
    public EnergyStorage energyHandler = new EnergyStorage(10000);

    public BreedingChamberBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.BREEDING_CHAMBER.get(), pos, state);
    }

    private void reset() {
        this.recipeProgress = 0;
        this.currentBreedingRecipes = new ArrayList<RecipeHolder<BeeBreedingRecipe>>();
        this.setRunning(false);
        this.setChanged();
    }

    private void setRunning(boolean running) {
        this.isRunning = running;
    }

    private void setRecipe(RecipeHolder<BeeBreedingRecipe> recipe) {
        this.chosenRecipe = recipe;
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public RecipeHolder<BeeBreedingRecipe> getCurrentRecipe() {
        return this.chosenRecipe;
    }

    @Override
    public int getRecipeProgress() {
        return this.recipeProgress;
    }

    @Override
    public int getProcessingTime(RecipeHolder<? extends TimedRecipeInterface> recipe) {
        return (int)((double)(recipe != null ? ((TimedRecipeInterface)recipe.value()).getProcessingTime() : 6000) * this.getProcessingTimeModifier());
    }

    protected double getProcessingTimeModifier() {
        double timeUpgradeModifier = 1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(0.0, timeUpgradeModifier);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, BreedingChamberBlockEntity blockEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockEntity.isRunning) {
                blockEntity.energyHandler.extractEnergy((int)((double)((Integer)ProductiveBeesConfig.GENERAL.breedingChamberPowerUse.get()).intValue() * blockEntity.getEnergyConsumptionModifier()), false);
            }
            if (!blockEntity.inventoryHandler.getStackInSlot(1).isEmpty() && !blockEntity.inventoryHandler.getStackInSlot(2).isEmpty()) {
                if (blockEntity.currentBreedingRecipes.isEmpty() && ++blockEntity.recipeLookupCooldown > 0) {
                    ItemStack cage1 = blockEntity.inventoryHandler.getStackInSlot(1);
                    ItemStack cage2 = blockEntity.inventoryHandler.getStackInSlot(2);
                    if (!cage1.isEmpty() && !cage2.isEmpty()) {
                        BeeHelper.IdentifierInventory beeInv = new BeeHelper.IdentifierInventory(BeeCage.getBeeType(cage1), BeeCage.getBeeType(cage2));
                        blockEntity.currentBreedingRecipes = BeeHelper.getBreedingRecipes(beeInv, serverLevel);
                        if (blockEntity.currentBreedingRecipes.size() > 0 && !blockEntity.currentBreedingRecipes.contains(blockEntity.chosenRecipe)) {
                            blockEntity.setRecipe(blockEntity.currentBreedingRecipes.get(level.random.nextInt(blockEntity.currentBreedingRecipes.size())));
                        }
                        blockEntity.recipeLookupCooldown = -20;
                    }
                }
                if (blockEntity.isRunning || !blockEntity.currentBreedingRecipes.isEmpty() && blockEntity.canProcessInput(blockEntity.inventoryHandler, true)) {
                    blockEntity.setRunning(true);
                    int totalTime = blockEntity.getProcessingTime(blockEntity.chosenRecipe);
                    if (blockEntity.recipeProgress == 0) {
                        ItemStack cage1 = blockEntity.inventoryHandler.getStackInSlot(1);
                        ItemStack cage2 = blockEntity.inventoryHandler.getStackInSlot(2);
                        CompoundTag bee1Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage1));
                        CompoundTag bee2Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage2));
                        blockEntity.inventoryHandler.getStackInSlot(3).shrink(bee1Data != null ? bee1Data.getInt("breedingItemCount") : 1);
                        blockEntity.inventoryHandler.getStackInSlot(4).shrink(bee2Data != null ? bee2Data.getInt("breedingItemCount") : 1);
                    }
                    if (++blockEntity.recipeProgress >= totalTime && blockEntity.completeBreeding(blockEntity.inventoryHandler)) {
                        blockEntity.reset();
                    }
                    blockEntity.recipeProgress = Math.min(blockEntity.recipeProgress, totalTime);
                }
            } else {
                blockEntity.reset();
            }
        }
    }

    protected double getEnergyConsumptionModifier() {
        double timeUpgradeModifier = (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get()));
        return Math.max(1.0, timeUpgradeModifier);
    }

    private boolean canProcessInput(IItemHandlerModifiable invHandler, boolean firstRun) {
        boolean bee2IsBaby;
        int energy = this.energyHandler.getEnergyStored();
        ItemStack cage1 = invHandler.getStackInSlot(1);
        ItemStack cage2 = invHandler.getStackInSlot(2);
        CompoundTag bee1Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage1));
        CompoundTag bee2Data = BeeReloadListener.INSTANCE.getData(BeeCage.getBeeType(cage2));
        boolean bee1IsBaby = BeeCage.isFilled(cage1) && ((CustomData)cage1.get(DataComponents.CUSTOM_DATA)).getUnsafe().contains("Age") && ((CustomData)cage1.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("Age") < 0;
        boolean bl = bee2IsBaby = BeeCage.isFilled(cage2) && ((CustomData)cage2.get(DataComponents.CUSTOM_DATA)).getUnsafe().contains("Age") && ((CustomData)cage2.get(DataComponents.CUSTOM_DATA)).copyTag().getInt("Age") < 0;
        if (bee1IsBaby || bee2IsBaby) {
            return false;
        }
        Ingredient breedingIngredient1 = Ingredient.of(ModTags.DEFAULT_BREEDING);
        int breedingCount1 = 1;
        Ingredient breedingIngredient2 = Ingredient.of(ModTags.DEFAULT_BREEDING);
        int breedingCount2 = 1;
        if (bee1Data != null) {
            breedingIngredient1 = ConfigurableBee.getBreedingIngredientFromString(bee1Data.getString("breedingItem"));
            breedingCount1 = bee1Data.getInt("breedingItemCount");
        }
        if (bee2Data != null) {
            breedingIngredient2 = ConfigurableBee.getBreedingIngredientFromString(bee2Data.getString("breedingItem"));
            breedingCount2 = bee2Data.getInt("breedingItemCount");
        }
        ItemStack breedingItem1 = invHandler.getStackInSlot(3);
        ItemStack breedingItem2 = invHandler.getStackInSlot(4);
        return energy > (Integer)ProductiveBeesConfig.GENERAL.incubatorPowerUse.get() && (!firstRun || breedingIngredient1.test(breedingItem1) && breedingCount1 <= breedingItem1.getCount() && breedingIngredient2.test(breedingItem2) && breedingCount2 <= breedingItem2.getCount());
    }

    private boolean completeBreeding(IItemHandlerModifiable invHandler) {
        BeeIngredient beeIngredient;
        Entity offspring;
        if (this.level != null && this.chosenRecipe != null && invHandler.getStackInSlot(5).isEmpty() && invHandler.getStackInSlot(0).getItem() instanceof BeeCage && this.canProcessInput(invHandler, false) && (offspring = (beeIngredient = ((BeeBreedingRecipe)this.chosenRecipe.value()).offspring.get()).getBeeEntity().create(this.level)) instanceof Bee) {
            Bee bee1;
            Bee bee = (Bee)offspring;
            if (bee instanceof ConfigurableBee) {
                ((ConfigurableBee)bee).setBeeType(beeIngredient.getBeeType().toString());
                ((ConfigurableBee)bee).setDefaultAttributes();
            }
            if ((bee1 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(1), this.level, true)) != null) {
                Bee bee2 = BeeCage.getEntityFromStack(invHandler.getStackInSlot(2), this.level, true);
                BeeHelper.setOffspringAttributes(bee, bee1, (AgeableMob)bee2);
            }
            bee.setAge(-24000);
            ItemStack cage = invHandler.getStackInSlot(0);
            ItemStack newCage = new ItemStack((ItemLike)cage.getItem());
            BeeCage.captureEntity(bee, newCage);
            cage.shrink(1);
            invHandler.setStackInSlot(5, newCage);
            return true;
        }
        return false;
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        Optional recipe;
        super.loadPacketNBT(tag, provider);
        if (tag.contains("ChosenRecipe") && this.level != null && (recipe = this.level.getRecipeManager().byKey(ResourceLocation.parse((String)tag.getString("ChosenRecipe")))).isPresent() && ((RecipeHolder)recipe.get()).value() instanceof BeeBreedingRecipe) {
            this.setRecipe((RecipeHolder<BeeBreedingRecipe>)((RecipeHolder)recipe.get()));
        }
        this.recipeProgress = tag.getInt("RecipeProgress");
        this.isRunning = tag.contains("IsRunning") && tag.getBoolean("IsRunning");
    }

    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        super.savePacketNBT(tag, provider);
        if (this.chosenRecipe != null) {
            tag.putString("ChosenRecipe", this.chosenRecipe.id().toString());
        }
        tag.putInt("RecipeProgress", this.recipeProgress);
        tag.putBoolean("IsRunning", this.isRunning);
    }

    @Nonnull
    public Component getName() {
        return Component.translatable((String)((Block)ModBlocks.BREEDING_CHAMBER.get()).getDescriptionId());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new BreedingChamberContainer(windowId, playerInventory, this);
    }

    public IItemHandler getItemHandler() {
        return this.inventoryHandler;
    }

    public EnergyStorage getEnergyHandler() {
        return this.energyHandler;
    }
}

