/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block.entity;

import cy.jdkdigital.productivebees.ProductiveBees;
import cy.jdkdigital.productivebees.ProductiveBeesConfig;
import cy.jdkdigital.productivebees.capabilities.attributes.BeeAttributesHandler;
import cy.jdkdigital.productivebees.common.block.AdvancedBeehive;
import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import cy.jdkdigital.productivebees.common.crafting.ingredient.BeeIngredientFactory;
import cy.jdkdigital.productivebees.common.entity.bee.ConfigurableBee;
import cy.jdkdigital.productivebees.common.entity.bee.IProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.ProductiveBee;
import cy.jdkdigital.productivebees.common.entity.bee.SolitaryBee;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import cy.jdkdigital.productivebees.common.item.Gene;
import cy.jdkdigital.productivebees.container.AdvancedBeehiveContainer;
import cy.jdkdigital.productivebees.init.ModBlockEntityTypes;
import cy.jdkdigital.productivebees.init.ModEntities;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.state.properties.VerticalHive;
import cy.jdkdigital.productivebees.util.BeeHelper;
import cy.jdkdigital.productivebees.util.GeneAttribute;
import cy.jdkdigital.productivebees.util.GeneValue;
import cy.jdkdigital.productivelib.common.block.entity.InventoryHandlerHelper;
import cy.jdkdigital.productivelib.common.block.entity.UpgradeableBlockEntity;
import cy.jdkdigital.productivelib.registry.LibItems;
import cy.jdkdigital.productivelib.registry.ModDataComponents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;

public class AdvancedBeehiveBlockEntity
extends AdvancedBeehiveBlockEntityAbstract
implements MenuProvider,
UpgradeableBlockEntity,
Container {
    protected int specialTickCounter = 0;
    protected int abandonCountdown = 0;
    public IItemHandlerModifiable inventoryHandler = new InventoryHandlerHelper.BlockEntityItemStackHandler(this, 12, (BlockEntity)this){

        public boolean isInputSlotItem(int slot, ItemStack item) {
            if (slot == 11) {
                AdvancedBeehiveBlockEntity advancedBeehiveBlockEntity;
                BlockEntity blockEntity;
                return item.getItem() instanceof BeeCage && (blockEntity = this.blockEntity) instanceof AdvancedBeehiveBlockEntity && (advancedBeehiveBlockEntity = (AdvancedBeehiveBlockEntity)blockEntity).isSim();
            }
            if (slot == 0 && item.is(Blocks.SPONGE.asItem())) {
                return true;
            }
            return super.isInputSlotItem(slot, item);
        }

        public boolean isInputSlot(int slot) {
            return slot == 11 || super.isInputSlot(slot);
        }

        protected void onContentsChanged(int slot) {
            Level level;
            ItemStack itemInBottleSlot;
            super.onContentsChanged(slot);
            if (slot == 0 && !(itemInBottleSlot = this.getStackInSlot(0)).isEmpty() && itemInBottleSlot.is(Blocks.SPONGE.asItem()) && (level = this.blockEntity.getLevel()) instanceof ServerLevel) {
                ServerLevel level2 = (ServerLevel)level;
                level2.setBlockAndUpdate(this.blockEntity.getBlockPos(), (BlockState)level2.getBlockState(this.blockEntity.getBlockPos()).setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
            }
        }
    };
    protected IItemHandlerModifiable upgradeHandler = new InventoryHandlerHelper.UpgradeHandler(4, (BlockEntity)this, List.of((Item)LibItems.UPGRADE_TIME.get(), (Item)LibItems.UPGRADE_TIME_2.get(), (Item)LibItems.UPGRADE_BLOCK.get(), (Item)LibItems.UPGRADE_ANTI_TELEPORT.get(), (Item)LibItems.UPGRADE_GENE_SAMPLER.get(), (Item)LibItems.UPGRADE_CHILD.get(), (Item)LibItems.UPGRADE_ADULT.get(), (Item)LibItems.UPGRADE_ENTITY_FILTER.get(), (Item)LibItems.UPGRADE_RANGE.get(), (Item)LibItems.UPGRADE_SIMULATOR.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_2.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_3.get(), (Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()));

    public AdvancedBeehiveBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntityTypes.ADVANCED_HIVE.get(), pos, state);
    }

    public AdvancedBeehiveBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
        this.MAX_BEES = 3;
    }

    @Nonnull
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        return new AdvancedBeehiveContainer(windowId, playerInventory, this);
    }

    @Nonnull
    public Component getDisplayName() {
        return Component.translatable((String)this.getBlockState().getBlock().getDescriptionId());
    }

    public boolean isSedated() {
        return true;
    }

    public boolean isSim() {
        return (Boolean)ProductiveBeesConfig.BEES.allowBeeSimulation.get() != false && (this.getUpgradeCount((Item)LibItems.UPGRADE_SIMULATOR.get()) > 0 || this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_3.get()) > 0 || this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()) > 0);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, AdvancedBeehiveBlockEntity blockEntity) {
        Object bees;
        if (++blockEntity.specialTickCounter > (Integer)ProductiveBeesConfig.GENERAL.hiveTickRate.get()) {
            EntityType beeType;
            ConfigurableBee newBee;
            blockEntity.specialTickCounter = 0;
            BlockPos front = pos.relative((Direction)state.getValue((Property)BeehiveBlock.FACING));
            if (level.random.nextDouble() <= (Double)ProductiveBeesConfig.BEES.spawnUndeadBeesChance.get() && level.isNight() && level.getBlockState(front).getCollisionShape((BlockGetter)level, front).isEmpty() && blockEntity.getOccupantCount() + blockEntity.beesOutsideHive() == 0 && level.getBrightness(LightLayer.BLOCK, front) == 0 && (bees = level.getEntitiesOfClass(Bee.class, new AABB(pos).inflate(3.0, 3.0, 3.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get() && (newBee = (ConfigurableBee)(beeType = (EntityType)ModEntities.CONFIGURABLE_BEE.get()).create(level)) != null) {
                if (level.random.nextBoolean()) {
                    newBee.setBeeType("productivebees:skeletal");
                } else {
                    newBee.setBeeType("productivebees:zombie");
                }
                newBee.setDefaultAttributes();
                newBee.hivePos = pos;
                blockEntity.addOccupant((Entity)newBee);
            }
        }
        if (blockEntity.tickCounter % 23 == 0 && (bees = blockEntity.inventoryHandler) instanceof InventoryHandlerHelper.BlockEntityItemStackHandler) {
            InventoryHandlerHelper.BlockEntityItemStackHandler itemStackHandler = (InventoryHandlerHelper.BlockEntityItemStackHandler)bees;
            if (state.getBlock() instanceof AdvancedBeehive) {
                ItemStack cageStack;
                ItemStack bottles;
                int honeyLevel = (Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL);
                if (honeyLevel >= 5 && !(bottles = itemStackHandler.getStackInSlot(0)).isEmpty() && bottles.is(Items.GLASS_BOTTLE)) {
                    boolean addedBottle;
                    ItemStack filledBottle = new ItemStack((ItemLike)Items.HONEY_BOTTLE);
                    boolean bl = addedBottle = itemStackHandler.addOutput(filledBottle).getCount() == 0;
                    if (addedBottle) {
                        itemStackHandler.addOutput(new ItemStack((ItemLike)Items.HONEYCOMB));
                        bottles.shrink(1);
                        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(honeyLevel - 5)));
                    }
                }
                if (blockEntity.isSim() && !(cageStack = itemStackHandler.getStackInSlot(11)).isEmpty() && cageStack.getItem() instanceof BeeCage) {
                    if (BeeCage.isFilled(cageStack) && (!cageStack.getItem().equals(ModItems.STURDY_BEE_CAGE.get()) || itemStackHandler.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.getItem()))))) {
                        Bee bee;
                        if (!blockEntity.isFull() && (bee = BeeCage.getEntityFromStack(cageStack, level, true)) != null && blockEntity.acceptsBee(bee) && !(bee instanceof SolitaryBee)) {
                            blockEntity.addOccupant((Entity)bee);
                            if (cageStack.getItem().equals(ModItems.STURDY_BEE_CAGE.get())) {
                                itemStackHandler.addOutput(new ItemStack((ItemLike)cageStack.getItem()));
                            }
                            cageStack.shrink(1);
                            level.sendBlockUpdated(pos, state, state, 3);
                        }
                    } else if (!blockEntity.isEmpty() && blockEntity.getOccupantCount() > 0) {
                        boolean[] hasRemoved = new boolean[]{false};
                        blockEntity.stored.removeIf(beeData -> {
                            Entity entity;
                            if (!hasRemoved[0] && (entity = beeData.toOccupant().createEntity(level, pos)) instanceof Bee) {
                                Bee beeEntity = (Bee)entity;
                                beeEntity.hivePos = blockEntity.worldPosition;
                                ItemStack filledCage = new ItemStack((ItemLike)cageStack.getItem());
                                BeeCage.captureEntity(beeEntity, filledCage);
                                if (itemStackHandler.canFitStacks(List.of(new ItemStack((ItemLike)cageStack.getItem())))) {
                                    cageStack.shrink(1);
                                    itemStackHandler.addOutput(filledCage);
                                    level.sendBlockUpdated(pos, state, state, 3);
                                    hasRemoved[0] = true;
                                    return true;
                                }
                            }
                            return false;
                        });
                    }
                }
            }
        }
        if (--blockEntity.abandonCountdown < 0) {
            blockEntity.abandonCountdown = 0;
        }
        AdvancedBeehiveBlockEntityAbstract.tick(level, pos, state, blockEntity);
    }

    public IItemHandlerModifiable getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Override
    protected int getTimeInHive(boolean hasNectar, @Nullable BeehiveBlockEntity.Occupant occupant) {
        double timeUpgradeModifier = Math.max(0.0, 1.0 - (Double)ProductiveBeesConfig.UPGRADES.timeBonus.get() * (double)(this.getUpgradeCount((Item)LibItems.UPGRADE_TIME_2.get()) * 2 + this.getUpgradeCount((Item)LibItems.UPGRADE_TIME.get())));
        return (int)((double)super.getTimeInHive(hasNectar, occupant) * timeUpgradeModifier + 20.0);
    }

    @Override
    protected void beeReleasePostAction(@Nonnull Level level, Bee beeEntity, BlockState state, BeehiveBlockEntity.BeeReleaseStatus beeState) {
        super.beeReleasePostAction(level, beeEntity, state, beeState);
        if (beeState == BeehiveBlockEntity.BeeReleaseStatus.HONEY_DELIVERED) {
            int samplerUpgrades;
            int breedingUpgrades;
            ProductiveBee productiveBee;
            if (!(beeEntity instanceof ProductiveBee) || !(productiveBee = (ProductiveBee)beeEntity).hasConverted()) {
                double upgradeMod = 1.0 + (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier.get() * (double)this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY.get()) + (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier2.get() * (double)this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_2.get()) + (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier3.get() * (double)this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_3.get()) + (Double)ProductiveBeesConfig.UPGRADES.productivityMultiplier4.get() * (double)this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get());
                boolean hasBlockUpgrade = this.getUpgradeCount((Item)LibItems.UPGRADE_BLOCK.get()) + this.getUpgradeCount((Item)LibItems.UPGRADE_PRODUCTIVITY_4.get()) > 0;
                BeeHelper.getBeeProduce(level, beeEntity, hasBlockUpgrade, upgradeMod).forEach(stackIn -> {
                    IItemHandlerModifiable patt0$temp;
                    ItemStack stack = stackIn.copy();
                    if (!stack.isEmpty() && (patt0$temp = this.inventoryHandler) instanceof InventoryHandlerHelper.BlockEntityItemStackHandler) {
                        BeeAttributesHandler data;
                        GeneValue productivity;
                        InventoryHandlerHelper.BlockEntityItemStackHandler itemStackHandler = (InventoryHandlerHelper.BlockEntityItemStackHandler)patt0$temp;
                        if (beeEntity.hasData(ProductiveBees.ATTRIBUTE_HANDLER) && (productivity = (data = (BeeAttributesHandler)beeEntity.getData(ProductiveBees.ATTRIBUTE_HANDLER)).getAttributeValue(GeneAttribute.PRODUCTIVITY)).getValue() > 0) {
                            if (stack.getCount() == 1) {
                                stack.grow(productivity.getValue());
                            } else {
                                float modifier = (1.0f / ((float)productivity.getValue() + 2.0f) + ((float)productivity.getValue() + 1.0f) / 2.0f) * (float)stack.getCount();
                                stack.grow(Math.round(modifier));
                            }
                        }
                        itemStackHandler.addOutput(stack);
                    }
                });
                ItemStack itemInBottleSlot = this.inventoryHandler.getStackInSlot(0);
                if (!itemInBottleSlot.isEmpty() && itemInBottleSlot.is(Blocks.SPONGE.asItem())) {
                    level.setBlockAndUpdate(this.getBlockPos(), (BlockState)state.setValue((Property)BeehiveBlock.HONEY_LEVEL, (Comparable)Integer.valueOf(0)));
                }
            }
            if ((breedingUpgrades = this.getUpgradeCount((Item)LibItems.UPGRADE_CHILD.get())) > 0 && !beeEntity.isBaby() && this.getOccupantCount() > 0 && (double)level.random.nextFloat() <= (Double)ProductiveBeesConfig.UPGRADES.breedingChance.get() * (double)breedingUpgrades) {
                Entity offspring;
                BeehiveBlockEntity.BeeData otherBeeInhabitant;
                Entity otherBee;
                List bees;
                IProductiveBee productiveBee2;
                Ingredient breedingIngredient;
                boolean canBreed;
                boolean bl = canBreed = !(beeEntity instanceof IProductiveBee) || ((IProductiveBee)beeEntity).canSelfBreed();
                if (canBreed && beeEntity instanceof IProductiveBee && !(breedingIngredient = (productiveBee2 = (IProductiveBee)beeEntity).getBreedingIngredient()).test(Items.POPPY.getDefaultInstance())) {
                    canBreed = false;
                }
                if (canBreed && (bees = level.getEntitiesOfClass(Bee.class, new AABB(this.worldPosition).inflate(5.0, 5.0, 5.0))).size() < (Integer)ProductiveBeesConfig.UPGRADES.breedingMaxNearbyEntities.get() && (otherBee = (otherBeeInhabitant = (BeehiveBlockEntity.BeeData)this.stored.get(level.random.nextInt(this.getOccupantCount()))).toOccupant().createEntity(level, this.getBlockPos())) instanceof Bee && (offspring = BeeHelper.getBreedingResult(beeEntity, (AgeableMob)((Bee)otherBee), (ServerLevel)this.level)) instanceof Bee) {
                    Bee bee = (Bee)offspring;
                    BeeHelper.setOffspringAttributes(bee, beeEntity, (AgeableMob)((Bee)otherBee));
                    bee.setAge(-24000);
                    BlockPos frontPos = this.getBlockPos().relative((Direction)state.getValue((Property)BeehiveBlock.FACING));
                    bee.moveTo((double)frontPos.getX(), (double)((float)frontPos.getY() + 0.5f), (double)frontPos.getZ(), 0.0f, 0.0f);
                    level.addFreshEntity((Entity)bee);
                }
            }
            if ((samplerUpgrades = this.getUpgradeCount((Item)LibItems.UPGRADE_GENE_SAMPLER.get())) > 0 && !beeEntity.isBaby() && (double)level.random.nextFloat() <= (Double)ProductiveBeesConfig.UPGRADES.samplerChance.get() * (double)samplerUpgrades) {
                BeeAttributesHandler attributes = (BeeAttributesHandler)beeEntity.getData(ProductiveBees.ATTRIBUTE_HANDLER);
                GeneAttribute attribute = Arrays.stream(GeneAttribute.values()).toList().get(level.random.nextInt(GeneAttribute.values().length));
                if (attribute.equals((Object)GeneAttribute.TYPE)) {
                    String type = beeEntity instanceof ConfigurableBee ? ((ConfigurableBee)beeEntity).getBeeType().toString() : beeEntity.getEncodeId();
                    ((InventoryHandlerHelper.BlockEntityItemStackHandler)this.inventoryHandler).addOutput(Gene.getStack(type, level.random.nextInt(4) + 1));
                } else {
                    GeneValue value = attributes.getAttributeValue(attribute);
                    ((InventoryHandlerHelper.BlockEntityItemStackHandler)this.inventoryHandler).addOutput(Gene.getStack(attribute, value.getSerializedName(), 1, level.random.nextInt(4) + 1));
                }
            }
        }
    }

    protected int beesOutsideHive() {
        int timeInHive = this.getTimeInHive(true, null);
        return timeInHive > 0 ? (int)Math.ceil(this.abandonCountdown % timeInHive) : 0;
    }

    public boolean acceptsUpgrades() {
        return this.getBlockState().getValue(AdvancedBeehive.EXPANDED) != VerticalHive.NONE;
    }

    @Override
    public boolean acceptsBee(Bee bee) {
        boolean isInFilters = false;
        List filters = this.getInstalledUpgrades((Item)LibItems.UPGRADE_ENTITY_FILTER.get());
        for (ItemStack filter : filters) {
            List entities = (List)filter.getOrDefault(ModDataComponents.ENTITY_TYPE_LIST, new ArrayList());
            for (ResourceLocation allowedBee : entities) {
                String type = BeeIngredientFactory.getIngredientKey(bee);
                if (!allowedBee.toString().equals(type)) continue;
                isInFilters = true;
            }
        }
        return filters.isEmpty() || isInFilters;
    }

    @Override
    public void loadPacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        ItemStackHandler serializable;
        IItemHandlerModifiable iItemHandlerModifiable;
        super.loadPacketNBT(tag, provider);
        if (tag.contains("inv") && (iItemHandlerModifiable = this.inventoryHandler) instanceof ItemStackHandler) {
            serializable = (ItemStackHandler)iItemHandlerModifiable;
            serializable.deserializeNBT(provider, tag.getCompound("inv"));
        }
        if (tag.contains("upgrades") && (iItemHandlerModifiable = this.upgradeHandler) instanceof ItemStackHandler) {
            serializable = (ItemStackHandler)iItemHandlerModifiable;
            serializable.deserializeNBT(provider, tag.getCompound("upgrades"));
        }
        this.MAX_BEES = tag.contains("max_bees") ? tag.getInt("max_bees") : this.MAX_BEES;
        this.specialTickCounter = tag.contains("specialTickCounter") ? tag.getInt("specialTickCounter") : 0;
    }

    @Override
    public void savePacketNBT(CompoundTag tag, HolderLookup.Provider provider) {
        ItemStackHandler serializable;
        super.savePacketNBT(tag, provider);
        IItemHandlerModifiable iItemHandlerModifiable = this.inventoryHandler;
        if (iItemHandlerModifiable instanceof ItemStackHandler) {
            serializable = (ItemStackHandler)iItemHandlerModifiable;
            tag.put("inv", (Tag)serializable.serializeNBT(provider));
        }
        if ((iItemHandlerModifiable = this.upgradeHandler) instanceof ItemStackHandler) {
            serializable = (ItemStackHandler)iItemHandlerModifiable;
            tag.put("upgrades", (Tag)serializable.serializeNBT(provider));
        }
        tag.putInt("max_bees", this.MAX_BEES);
        tag.putInt("specialTickCounter", this.specialTickCounter);
    }

    public int getContainerSize() {
        return this.inventoryHandler.getSlots();
    }

    public ItemStack getItem(int pSlot) {
        return this.inventoryHandler.getStackInSlot(pSlot);
    }

    public ItemStack removeItem(int pSlot, int pAmount) {
        return this.inventoryHandler.extractItem(pSlot, pAmount, false);
    }

    public ItemStack removeItemNoUpdate(int pSlot) {
        return this.inventoryHandler.extractItem(pSlot, this.inventoryHandler.getStackInSlot(pSlot).getCount(), false);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        this.inventoryHandler.setStackInSlot(pSlot, pStack);
    }

    public boolean stillValid(Player pPlayer) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)pPlayer);
    }

    public void clearContent() {
        for (int i = 0; i < this.inventoryHandler.getSlots(); ++i) {
            this.removeItem(i, this.inventoryHandler.getStackInSlot(i).getCount());
        }
    }
}

