/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.JarBlockEntity;
import cy.jdkdigital.productivebees.common.item.BeeCage;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Jar
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Jar.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)12.0, (double)12.5);

    public Jar(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nonnull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return 1;
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter world, BlockPos pos) {
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new JarBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.BLOCK_ENTITY_DATA)) {
            CompoundTag tag = ((CustomData)pStack.get(DataComponents.BLOCK_ENTITY_DATA)).copyTag();
            if (tag.contains("BlockEntityTag") && tag.getCompound("BlockEntityTag").contains("inv")) {
                CompoundTag invTag = tag.getCompound("BlockEntityTag").getCompound("inv");
                ListTag tagList = invTag.getList("Items", 10);
                if (tagList.size() > 0) {
                    CompoundTag itemTag = tagList.getCompound(0);
                    ItemStack cage = (ItemStack)ItemStack.parse((HolderLookup.Provider)pContext.registries(), (Tag)itemTag).get();
                    if (BeeCage.isFilled(cage)) {
                        String entityId = ((CustomData)cage.get(DataComponents.CUSTOM_DATA)).copyTag().getString("name");
                        pTootipComponents.add((Component)Component.translatable((String)"productivebees.information.jar.bee", (Object[])new Object[]{entityId}));
                    }
                } else {
                    pTootipComponents.add((Component)Component.translatable((String)"productivebees.information.jar.fill_tip"));
                }
            }
        } else {
            pTootipComponents.add((Component)Component.translatable((String)"productivebees.information.jar.fill_tip"));
        }
    }
}

