/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.FeederBlockEntity;
import cy.jdkdigital.productivebees.init.ModFluids;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.init.ModTags;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import org.jetbrains.annotations.Nullable;

public class Feeder
extends SlabBlock
implements EntityBlock {
    public static final BooleanProperty HONEYLOGGED = BooleanProperty.create((String)"honeylogged");

    public Feeder(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @javax.annotation.Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : FeederBlockEntity::tick;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HONEYLOGGED});
    }

    @javax.annotation.Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        if (fluidstate.is(ModTags.HONEY) && fluidstate.isSource() && state != null) {
            return (BlockState)state.setValue((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public boolean canPlaceLiquid(@Nullable Player pPlayer, BlockGetter pLevel, BlockPos pPos, BlockState pState, Fluid pFluid) {
        return pState.getValue((Property)TYPE) != SlabType.DOUBLE && (Boolean)pState.getValue((Property)BlockStateProperties.WATERLOGGED) == false && (pFluid == Fluids.WATER || pFluid.isSame((Fluid)ModFluids.HONEY.get()));
    }

    public boolean placeLiquid(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        if (!((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            boolean isHoney;
            boolean bl = isHoney = fluidState.getType().isSame((Fluid)ModFluids.HONEY.get()) && fluidState.isSource();
            if (fluidState.getType() == Fluids.WATER || isHoney) {
                BlockEntity blockEntity;
                if (!level.isClientSide() && (blockEntity = level.getBlockEntity(pos)) instanceof FeederBlockEntity) {
                    FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
                    CompoundTag nbt = new CompoundTag();
                    feederBlockEntity.savePacketNBT(nbt, (HolderLookup.Provider)level.registryAccess());
                    level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(isHoney)), 3);
                    level.scheduleTick(pos, fluidState.getType(), fluidState.getType().getTickDelay((LevelReader)level));
                    feederBlockEntity.loadPacketNBT(nbt, (HolderLookup.Provider)level.registryAccess());
                }
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)HONEYLOGGED) != false ? ((BaseFlowingFluid)ModFluids.HONEY.get()).getSource(false) : super.getFluidState(state);
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        super.onBlockStateChange(level, pos, oldState, newState);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
            CompoundTag nbt = new CompoundTag();
            feederBlockEntity.savePacketNBT(nbt, (HolderLookup.Provider)level.registryAccess());
            feederBlockEntity.refreshInventoryHandler();
            feederBlockEntity.loadPacketNBT(nbt, (HolderLookup.Provider)level.registryAccess());
        }
    }

    public ItemStack pickupBlock(@javax.annotation.Nullable Player pPlayer, LevelAccessor pLevel, BlockPos pPos, BlockState pState) {
        if (((Boolean)pState.getValue((Property)HONEYLOGGED)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)HONEYLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return new ItemStack((ItemLike)ModItems.HONEY_BUCKET.get());
        }
        return super.pickupBlock(pPlayer, pLevel, pPos, pState);
    }

    @javax.annotation.Nullable
    public MenuProvider getMenuProvider(BlockState state, Level world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        return tile instanceof MenuProvider ? (MenuProvider)tile : null;
    }

    public void onRemove(BlockState oldState, @Nonnull Level worldIn, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity tileEntity;
        if (oldState.getBlock() != newState.getBlock() && (tileEntity = worldIn.getBlockEntity(pos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)tileEntity;
            for (int slot = 0; slot < feederBlockEntity.inventoryHandler.getSlots(); ++slot) {
                Containers.dropItemStack((Level)worldIn, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)feederBlockEntity.inventoryHandler.getStackInSlot(slot));
            }
        }
        super.onRemove(oldState, worldIn, pos, newState, isMoving);
    }

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        Block heldBlock;
        ItemStack heldItem = pPlayer.getItemInHand(pHand);
        if (heldItem.getItem() instanceof BlockItem && (heldBlock = ((BlockItem)heldItem.getItem()).getBlock()) instanceof SlabBlock && !(heldBlock instanceof Feeder) && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof FeederBlockEntity) {
            ((FeederBlockEntity)blockEntity).baseBlock = heldBlock;
            blockEntity.setChanged();
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof FeederBlockEntity) {
            FeederBlockEntity feederBlockEntity = (FeederBlockEntity)blockEntity;
            pPlayer.openMenu((MenuProvider)feederBlockEntity, pPos);
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    @javax.annotation.Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FeederBlockEntity(pos, state);
    }
}

