/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.CombBlock;
import cy.jdkdigital.productivebees.common.block.entity.CombBlockBlockEntity;
import cy.jdkdigital.productivebees.init.ModDataComponents;
import cy.jdkdigital.productivebees.init.ModItems;
import cy.jdkdigital.productivebees.util.BeeCreator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.HitResult;

public class ConfigurableCombBlock
extends CombBlock
implements EntityBlock {
    public ConfigurableCombBlock(BlockBehaviour.Properties properties, String colorCode) {
        super(properties, colorCode);
    }

    @Override
    public int getColor(BlockAndTintGetter world, BlockPos pos) {
        BlockEntity tileEntity;
        if (world != null && pos != null && (tileEntity = world.getBlockEntity(pos)) instanceof CombBlockBlockEntity) {
            return ((CombBlockBlockEntity)tileEntity).getColor();
        }
        return this.getColor();
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CombBlockBlockEntity(pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack pStack) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof CombBlockBlockEntity && pStack.has(ModDataComponents.BEE_TYPE)) {
            ((CombBlockBlockEntity)tileEntity).setType((ResourceLocation)pStack.get(ModDataComponents.BEE_TYPE));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        CombBlockBlockEntity combBlockBlockEntity;
        ResourceLocation type;
        ItemStack stack = new ItemStack((ItemLike)ModItems.CONFIGURABLE_COMB_BLOCK.get());
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CombBlockBlockEntity && (type = (combBlockBlockEntity = (CombBlockBlockEntity)blockEntity).getCombType()) != null) {
            BeeCreator.setType(type, stack);
        }
        return stack;
    }
}

