/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivebees.common.block;

import cy.jdkdigital.productivebees.common.block.entity.AdvancedBeehiveBlockEntityAbstract;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.MinecartTNT;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AdvancedBeehiveAbstract
extends BaseEntityBlock {
    public AdvancedBeehiveAbstract(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public int getMaxHoneyLevel() {
        return 5;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveBlockEntityAbstract = (AdvancedBeehiveBlockEntityAbstract)blockEntity;
            return beehiveBlockEntityAbstract.getOccupantCount();
        }
        return 0;
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        CompoundTag stateNBT;
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
        if (pStack.has(DataComponents.BLOCK_ENTITY_DATA) && (stateNBT = ((CustomData)pStack.get(DataComponents.BLOCK_ENTITY_DATA)).getUnsafe()) != null && stateNBT.contains("honey_level")) {
            String honeyLevel = stateNBT.getString("honey_level");
            pTootipComponents.add((Component)Component.translatable((String)"productivebees.hive.tooltip.honey_level", (Object[])new Object[]{honeyLevel}).withStyle(ChatFormatting.GOLD));
        }
        if (pStack.has(DataComponents.BEES)) {
            List occupants = (List)pStack.get(DataComponents.BEES);
            if (occupants != null && !occupants.isEmpty()) {
                pTootipComponents.add((Component)Component.translatable((String)"productivebees.hive.tooltip.bees").withStyle(ChatFormatting.BOLD));
                for (int i = 0; i < occupants.size(); ++i) {
                    CompoundTag tag = ((BeehiveBlockEntity.Occupant)occupants.get(i)).entityData().getUnsafe();
                    String name = tag.contains("Name") ? tag.getString("Name") : "";
                    pTootipComponents.add((Component)Component.literal((String)name).withStyle(ChatFormatting.GREEN));
                }
            } else {
                pTootipComponents.add((Component)Component.translatable((String)"productivebees.hive.tooltip.empty"));
            }
        }
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (state.hasProperty((Property)BeehiveBlock.HONEY_LEVEL) && (Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= this.getMaxHoneyLevel()) {
            for (int i = 0; i < random.nextInt(1) + 1; ++i) {
                this.dripHoney(world, pos, state);
            }
        }
    }

    private void dripHoney(Level world, BlockPos pos, BlockState state) {
        VoxelShape shape;
        double shapeEnd;
        if (state.getFluidState().isEmpty() && world.random.nextFloat() >= 0.3f && (shapeEnd = (shape = state.getCollisionShape((BlockGetter)world, pos)).max(Direction.Axis.Y)) >= 1.0 && !state.is(BlockTags.IMPERMEABLE)) {
            double shapeStart = shape.min(Direction.Axis.Y);
            if (shapeStart > 0.0) {
                AdvancedBeehiveAbstract.spawnParticle(world, pos, shape, (double)pos.getY() + shapeStart - 0.05);
            } else {
                BlockPos posDown = pos.below();
                BlockState stateDown = world.getBlockState(posDown);
                VoxelShape shapeDown = stateDown.getCollisionShape((BlockGetter)world, posDown);
                double shapeDownEnd = shapeDown.max(Direction.Axis.Y);
                if ((shapeDownEnd < 1.0 || !stateDown.isCollisionShapeFullBlock((BlockGetter)world, posDown)) && stateDown.getFluidState().isEmpty()) {
                    AdvancedBeehiveAbstract.spawnParticle(world, pos, shape, (double)pos.getY() - 0.05);
                }
            }
        }
    }

    private static void spawnParticle(Level level, BlockPos pos, VoxelShape shape, double p_226880_4_) {
        AdvancedBeehiveAbstract.spawnFluidParticle(level, (double)pos.getX() + shape.min(Direction.Axis.X), (double)pos.getX() + shape.max(Direction.Axis.X), (double)pos.getZ() + shape.min(Direction.Axis.Z), (double)pos.getZ() + shape.max(Direction.Axis.Z), p_226880_4_);
    }

    private static void spawnFluidParticle(Level level, double d1, double d2, double d3, double d4, double d5) {
        level.addParticle((ParticleOptions)ParticleTypes.DRIPPING_HONEY, Mth.lerp((double)level.random.nextDouble(), (double)d1, (double)d2), d5, Mth.lerp((double)level.random.nextDouble(), (double)d3, (double)d4), 0.0, 0.0, 0.0);
    }

    @Nonnull
    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void attack(BlockState state, Level level, BlockPos pos, Player player) {
        BlockEntity tileEntity;
        ItemStack heldItem = player.getMainHandItem();
        if (level instanceof ServerLevel && heldItem.getItem().equals(Items.STICK) && (tileEntity = level.getBlockEntity(pos)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.emptyAllLivingFromHive(player, state, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
        }
        super.attack(state, level, pos, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        BlockEntity tileEntity;
        Entity entity = (Entity)builder.getOptionalParameter(LootContextParams.THIS_ENTITY);
        if ((entity instanceof PrimedTnt || entity instanceof Creeper || entity instanceof WitherSkull || entity instanceof WitherBoss || entity instanceof MinecartTNT) && (tileEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.emptyAllLivingFromHive(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.getDrops(state, builder);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState state1, LevelAccessor world, BlockPos pos, BlockPos fireBlockPos) {
        BlockEntity tileEntity;
        if (world.getBlockState(fireBlockPos).getBlock() instanceof FireBlock && (tileEntity = world.getBlockEntity(pos)) instanceof AdvancedBeehiveBlockEntityAbstract) {
            AdvancedBeehiveBlockEntityAbstract beehiveTileEntity = (AdvancedBeehiveBlockEntityAbstract)tileEntity;
            beehiveTileEntity.emptyAllLivingFromHive(null, state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY);
        }
        return super.updateShape(state, direction, state1, world, pos, fireBlockPos);
    }
}

