/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.modcompat.vanilla;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.GlowItemFrame;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.SmithingTableBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.entity.SmokerBlockEntity;
import net.neoforged.neoforge.capabilities.BaseCapability;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.IBlockCapabilityProvider;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import org.cyclops.commoncapabilities.CommonCapabilities;
import org.cyclops.commoncapabilities.RegistryEntries;
import org.cyclops.commoncapabilities.api.capability.Capabilities;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IRecipeHandler;
import org.cyclops.commoncapabilities.api.capability.temperature.ITemperature;
import org.cyclops.commoncapabilities.api.capability.work.IWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.energystorage.VanillaEntityItemFrameEnergyStorage;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.fluidhandler.VanillaEntityItemFrameFluidHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaBlockComposterItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemFrameItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaEntityItemItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemBundleItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.itemhandler.VanillaItemShulkerBoxItemHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaBrewingStandRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.recipehandler.VanillaRecipeTypeRecipeHandler;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaAbstractFurnaceTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaCampfireTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.temperature.VanillaUniversalBucketTemperature;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaAbstractFurnaceWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaBrewingStandWorker;
import org.cyclops.commoncapabilities.modcompat.vanilla.capability.work.VanillaCampfireWorker;
import org.cyclops.cyclopscore.modcompat.ICompatInitializer;
import org.cyclops.cyclopscore.modcompat.IModCompat;
import org.cyclops.cyclopscore.modcompat.capabilities.CapabilityConstructorRegistry;
import org.cyclops.cyclopscore.modcompat.capabilities.IBlockCapabilityConstructor;
import org.cyclops.cyclopscore.modcompat.capabilities.ICapabilityConstructor;

public class VanillaModCompat
implements IModCompat {
    public String getId() {
        return "minecraft";
    }

    public boolean isEnabledDefault() {
        return true;
    }

    public String getComment() {
        return "Furnace and Brewing stand capabilities.";
    }

    public ICompatInitializer createInitializer() {
        return () -> {
            CapabilityConstructorRegistry registry = CommonCapabilities._instance.getCapabilityConstructorRegistry();
            registry.registerBlockEntity(() -> BlockEntityType.FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<FurnaceBlockEntity, Direction, IWorker, BlockEntityType<FurnaceBlockEntity>>(this){

                public BaseCapability<IWorker, Direction> getCapability() {
                    return Capabilities.Worker.BLOCK;
                }

                public ICapabilityProvider<FurnaceBlockEntity, Direction, IWorker> createProvider(BlockEntityType<FurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.BLAST_FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<BlastFurnaceBlockEntity, Direction, IWorker, BlockEntityType<BlastFurnaceBlockEntity>>(this){

                public BaseCapability<IWorker, Direction> getCapability() {
                    return Capabilities.Worker.BLOCK;
                }

                public ICapabilityProvider<BlastFurnaceBlockEntity, Direction, IWorker> createProvider(BlockEntityType<BlastFurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.SMOKER, (ICapabilityConstructor)new ICapabilityConstructor<SmokerBlockEntity, Direction, IWorker, BlockEntityType<SmokerBlockEntity>>(this){

                public BaseCapability<IWorker, Direction> getCapability() {
                    return Capabilities.Worker.BLOCK;
                }

                public ICapabilityProvider<SmokerBlockEntity, Direction, IWorker> createProvider(BlockEntityType<SmokerBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceWorker((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.BREWING_STAND, (ICapabilityConstructor)new ICapabilityConstructor<BrewingStandBlockEntity, Direction, IWorker, BlockEntityType<BrewingStandBlockEntity>>(this){

                public BaseCapability<IWorker, Direction> getCapability() {
                    return Capabilities.Worker.BLOCK;
                }

                public ICapabilityProvider<BrewingStandBlockEntity, Direction, IWorker> createProvider(BlockEntityType<BrewingStandBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaBrewingStandWorker((BrewingStandBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.CAMPFIRE, (ICapabilityConstructor)new ICapabilityConstructor<CampfireBlockEntity, Direction, IWorker, BlockEntityType<CampfireBlockEntity>>(this){

                public BaseCapability<IWorker, Direction> getCapability() {
                    return Capabilities.Worker.BLOCK;
                }

                public ICapabilityProvider<CampfireBlockEntity, Direction, IWorker> createProvider(BlockEntityType<CampfireBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaCampfireWorker((CampfireBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<FurnaceBlockEntity, Direction, ITemperature, BlockEntityType<FurnaceBlockEntity>>(this){

                public BaseCapability<ITemperature, Direction> getCapability() {
                    return Capabilities.Temperature.BLOCK;
                }

                public ICapabilityProvider<FurnaceBlockEntity, Direction, ITemperature> createProvider(BlockEntityType<FurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.BLAST_FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<BlastFurnaceBlockEntity, Direction, ITemperature, BlockEntityType<BlastFurnaceBlockEntity>>(this){

                public BaseCapability<ITemperature, Direction> getCapability() {
                    return Capabilities.Temperature.BLOCK;
                }

                public ICapabilityProvider<BlastFurnaceBlockEntity, Direction, ITemperature> createProvider(BlockEntityType<BlastFurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.SMOKER, (ICapabilityConstructor)new ICapabilityConstructor<SmokerBlockEntity, Direction, ITemperature, BlockEntityType<SmokerBlockEntity>>(this){

                public BaseCapability<ITemperature, Direction> getCapability() {
                    return Capabilities.Temperature.BLOCK;
                }

                public ICapabilityProvider<SmokerBlockEntity, Direction, ITemperature> createProvider(BlockEntityType<SmokerBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaAbstractFurnaceTemperature((AbstractFurnaceBlockEntity)blockEntity);
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.CAMPFIRE, (ICapabilityConstructor)new ICapabilityConstructor<CampfireBlockEntity, Direction, ITemperature, BlockEntityType<CampfireBlockEntity>>(this){

                public BaseCapability<ITemperature, Direction> getCapability() {
                    return Capabilities.Temperature.BLOCK;
                }

                public ICapabilityProvider<CampfireBlockEntity, Direction, ITemperature> createProvider(BlockEntityType<CampfireBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaCampfireTemperature((CampfireBlockEntity)blockEntity);
                }
            });
            registry.registerInheritableItem(BucketItem.class, (ICapabilityConstructor)new ICapabilityConstructor<ItemStack, Void, ITemperature, BucketItem>(this){

                public BaseCapability<ITemperature, Void> getCapability() {
                    return Capabilities.Temperature.ITEM;
                }

                public ICapabilityProvider<ItemStack, Void, ITemperature> createProvider(BucketItem capabilityKey) {
                    return (itemStack, context) -> new VanillaUniversalBucketTemperature((ItemStack)itemStack);
                }
            });
            ICapabilityConstructor<ItemStack, Void, IItemHandler, ItemLike> shulkerboxConstructor = new ICapabilityConstructor<ItemStack, Void, IItemHandler, ItemLike>(this){

                public BaseCapability<IItemHandler, Void> getCapability() {
                    return Capabilities.ItemHandler.ITEM;
                }

                public ICapabilityProvider<ItemStack, Void, IItemHandler> createProvider(ItemLike host) {
                    return (itemStack, context) -> new VanillaItemShulkerBoxItemHandler((ItemStack)itemStack);
                }
            };
            registry.registerItem(() -> RegistryEntries.ITEM_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_WHITE_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_ORANGE_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_MAGENTA_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_BLUE_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_YELLOW_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIME_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PINK_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GRAY_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_LIGHT_GRAY_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_CYAN_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_PURPLE_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLUE_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BROWN_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_GREEN_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_RED_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BLACK_SHULKER_BOX.get(), (ICapabilityConstructor)shulkerboxConstructor);
            registry.registerItem(() -> RegistryEntries.ITEM_BUNDLE.get(), (ICapabilityConstructor)new ICapabilityConstructor<ItemStack, Void, IItemHandler, ItemLike>(this){

                public BaseCapability<IItemHandler, Void> getCapability() {
                    return Capabilities.ItemHandler.ITEM;
                }

                public ICapabilityProvider<ItemStack, Void, IItemHandler> createProvider(ItemLike host) {
                    return (itemStack, context) -> new VanillaItemBundleItemHandler((ItemStack)itemStack);
                }
            });
            registry.registerEntity(() -> EntityType.ITEM, (ICapabilityConstructor)new ICapabilityConstructor<ItemEntity, Void, IItemHandler, EntityType<ItemEntity>>(this){

                public BaseCapability<IItemHandler, Void> getCapability() {
                    return Capabilities.ItemHandler.ENTITY;
                }

                public ICapabilityProvider<ItemEntity, Void, IItemHandler> createProvider(EntityType<ItemEntity> host) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.ItemHandler.ITEM) != null) {
                            return new VanillaEntityItemItemHandler((ItemEntity)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<ItemFrame, Void, IItemHandler, EntityType<ItemFrame>>(this){

                public BaseCapability<IItemHandler, Void> getCapability() {
                    return Capabilities.ItemHandler.ENTITY;
                }

                public ICapabilityProvider<ItemFrame, Void, IItemHandler> createProvider(EntityType<ItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.ItemHandler.ITEM) != null) {
                            return new VanillaEntityItemFrameItemHandler((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.GLOW_ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<GlowItemFrame, Void, IItemHandler, EntityType<GlowItemFrame>>(this){

                public BaseCapability<IItemHandler, Void> getCapability() {
                    return Capabilities.ItemHandler.ENTITY;
                }

                public ICapabilityProvider<GlowItemFrame, Void, IItemHandler> createProvider(EntityType<GlowItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.ItemHandler.ITEM) != null) {
                            return new VanillaEntityItemFrameItemHandler((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerBlock(() -> (ComposterBlock)Blocks.COMPOSTER, (IBlockCapabilityConstructor)new IBlockCapabilityConstructor<ComposterBlock, Direction, IItemHandler, ComposterBlock>(this){

                public BaseCapability<IItemHandler, Direction> getCapability() {
                    return Capabilities.ItemHandler.BLOCK;
                }

                public IBlockCapabilityProvider<IItemHandler, Direction> createProvider(ComposterBlock capabilityKey) {
                    return (level, pos, state, blockEntity, side) -> new VanillaBlockComposterItemHandler(state, level, pos, (Direction)side);
                }
            });
            registry.registerEntity(() -> EntityType.ITEM, (ICapabilityConstructor)new ICapabilityConstructor<ItemEntity, Direction, IFluidHandler, EntityType<ItemEntity>>(this){

                public BaseCapability<IFluidHandler, Direction> getCapability() {
                    return Capabilities.FluidHandler.ENTITY;
                }

                public ICapabilityProvider<ItemEntity, Direction, IFluidHandler> createProvider(EntityType<ItemEntity> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.FluidHandler.ITEM) != null) {
                            new VanillaEntityItemFluidHandler((ItemEntity)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<ItemFrame, Direction, IFluidHandler, EntityType<ItemFrame>>(this){

                public BaseCapability<IFluidHandler, Direction> getCapability() {
                    return Capabilities.FluidHandler.ENTITY;
                }

                public ICapabilityProvider<ItemFrame, Direction, IFluidHandler> createProvider(EntityType<ItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.FluidHandler.ITEM) != null) {
                            new VanillaEntityItemFrameFluidHandler((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.GLOW_ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<GlowItemFrame, Direction, IFluidHandler, EntityType<GlowItemFrame>>(this){

                public BaseCapability<IFluidHandler, Direction> getCapability() {
                    return Capabilities.FluidHandler.ENTITY;
                }

                public ICapabilityProvider<GlowItemFrame, Direction, IFluidHandler> createProvider(EntityType<GlowItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.FluidHandler.ITEM) != null) {
                            new VanillaEntityItemFrameFluidHandler((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.ITEM, (ICapabilityConstructor)new ICapabilityConstructor<ItemEntity, Direction, IEnergyStorage, EntityType<ItemEntity>>(this){

                public BaseCapability<IEnergyStorage, Direction> getCapability() {
                    return Capabilities.EnergyStorage.ENTITY;
                }

                public ICapabilityProvider<ItemEntity, Direction, IEnergyStorage> createProvider(EntityType<ItemEntity> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                            new VanillaEntityItemEnergyStorage((ItemEntity)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<ItemFrame, Direction, IEnergyStorage, EntityType<ItemFrame>>(this){

                public BaseCapability<IEnergyStorage, Direction> getCapability() {
                    return Capabilities.EnergyStorage.ENTITY;
                }

                public ICapabilityProvider<ItemFrame, Direction, IEnergyStorage> createProvider(EntityType<ItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                            new VanillaEntityItemFrameEnergyStorage((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerEntity(() -> EntityType.GLOW_ITEM_FRAME, (ICapabilityConstructor)new ICapabilityConstructor<GlowItemFrame, Direction, IEnergyStorage, EntityType<GlowItemFrame>>(this){

                public BaseCapability<IEnergyStorage, Direction> getCapability() {
                    return Capabilities.EnergyStorage.ENTITY;
                }

                public ICapabilityProvider<GlowItemFrame, Direction, IEnergyStorage> createProvider(EntityType<GlowItemFrame> capabilityKey) {
                    return (entity, context) -> {
                        if (entity.getItem().getCapability(Capabilities.EnergyStorage.ITEM) != null) {
                            new VanillaEntityItemFrameEnergyStorage((ItemFrame)entity);
                        }
                        return null;
                    };
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.BREWING_STAND, (ICapabilityConstructor)new ICapabilityConstructor<BrewingStandBlockEntity, Direction, IRecipeHandler, BlockEntityType<BrewingStandBlockEntity>>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public ICapabilityProvider<BrewingStandBlockEntity, Direction, IRecipeHandler> createProvider(BlockEntityType<BrewingStandBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> VanillaBrewingStandRecipeHandler.getInstance();
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<FurnaceBlockEntity, Direction, IRecipeHandler, BlockEntityType<FurnaceBlockEntity>>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public ICapabilityProvider<FurnaceBlockEntity, Direction, IRecipeHandler> createProvider(BlockEntityType<FurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> ((FurnaceBlockEntity)blockEntity).getLevel(), RecipeType.SMELTING, size -> size == 1, c -> new SingleRecipeInput(c.getItem(0)));
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.BLAST_FURNACE, (ICapabilityConstructor)new ICapabilityConstructor<BlastFurnaceBlockEntity, Direction, IRecipeHandler, BlockEntityType<BlastFurnaceBlockEntity>>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public ICapabilityProvider<BlastFurnaceBlockEntity, Direction, IRecipeHandler> createProvider(BlockEntityType<BlastFurnaceBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> ((BlastFurnaceBlockEntity)blockEntity).getLevel(), RecipeType.BLASTING, size -> size == 1, c -> new SingleRecipeInput(c.getItem(0)));
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.SMOKER, (ICapabilityConstructor)new ICapabilityConstructor<SmokerBlockEntity, Direction, IRecipeHandler, BlockEntityType<SmokerBlockEntity>>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public ICapabilityProvider<SmokerBlockEntity, Direction, IRecipeHandler> createProvider(BlockEntityType<SmokerBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> ((SmokerBlockEntity)blockEntity).getLevel(), RecipeType.SMOKING, size -> size == 1, c -> new SingleRecipeInput(c.getItem(0)));
                }
            });
            registry.registerBlockEntity(() -> BlockEntityType.CAMPFIRE, (ICapabilityConstructor)new ICapabilityConstructor<CampfireBlockEntity, Direction, IRecipeHandler, BlockEntityType<CampfireBlockEntity>>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public ICapabilityProvider<CampfireBlockEntity, Direction, IRecipeHandler> createProvider(BlockEntityType<CampfireBlockEntity> capabilityKey) {
                    return (blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> ((CampfireBlockEntity)blockEntity).getLevel(), RecipeType.CAMPFIRE_COOKING, size -> size == 1, c -> new SingleRecipeInput(c.getItem(0)));
                }
            });
            registry.registerInheritableBlock(CraftingTableBlock.class, (IBlockCapabilityConstructor)new IBlockCapabilityConstructor<ComposterBlock, Direction, IRecipeHandler, Block>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public IBlockCapabilityProvider<IRecipeHandler, Direction> createProvider(Block capabilityKey) {
                    return (level, pos, state, blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> level, RecipeType.CRAFTING, size -> size > 0, CraftingContainer::asCraftInput);
                }
            });
            registry.registerBlock(() -> (StonecutterBlock)Blocks.STONECUTTER, (IBlockCapabilityConstructor)new IBlockCapabilityConstructor<StonecutterBlock, Direction, IRecipeHandler, StonecutterBlock>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public IBlockCapabilityProvider<IRecipeHandler, Direction> createProvider(StonecutterBlock capabilityKey) {
                    return (level, pos, state, blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> level, RecipeType.STONECUTTING, size -> size == 1, c -> new SingleRecipeInput(c.getItem(0)));
                }
            });
            registry.registerBlock(() -> (SmithingTableBlock)Blocks.SMITHING_TABLE, (IBlockCapabilityConstructor)new IBlockCapabilityConstructor<StonecutterBlock, Direction, IRecipeHandler, SmithingTableBlock>(this){

                public BaseCapability<IRecipeHandler, Direction> getCapability() {
                    return Capabilities.RecipeHandler.BLOCK;
                }

                public IBlockCapabilityProvider<IRecipeHandler, Direction> createProvider(SmithingTableBlock capabilityKey) {
                    return (level, pos, state, blockEntity, side) -> new VanillaRecipeTypeRecipeHandler(() -> level, RecipeType.SMITHING, size -> size == 1, c -> new SmithingRecipeInput(c.getItem(0), c.getItem(1), c.getItem(2)));
                }
            });
        };
    }
}

