/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.PrototypedIngredient;

public class PrototypedIngredientAlternativesItemStackTag
implements IPrototypedIngredientAlternatives<ItemStack, Integer> {
    public static final Serializer SERIALIZER = new Serializer();
    private static final LoadingCache<String, Collection<Item>> CACHE_OREDICT;
    private final List<String> keys;
    private final Integer matchCondition;
    private final long quantity;

    public PrototypedIngredientAlternativesItemStackTag(List<String> keys, Integer matchCondition, long quantity) {
        this.keys = keys;
        this.matchCondition = matchCondition;
        this.quantity = quantity;
    }

    @Override
    public Collection<IPrototypedIngredient<ItemStack, Integer>> getAlternatives() {
        IIngredientMatcher<ItemStack, Integer> matcher = IngredientComponent.ITEMSTACK.getMatcher();
        return this.keys.stream().flatMap(key -> {
            try {
                return ((Collection)CACHE_OREDICT.get(key)).stream();
            }
            catch (ExecutionException e) {
                return Stream.empty();
            }
        }).map(item -> matcher.withQuantity(new ItemStack((ItemLike)item), this.getQuantity())).map(itemStack -> new PrototypedIngredient<ItemStack, Integer>(IngredientComponent.ITEMSTACK, (ItemStack)itemStack, this.matchCondition)).collect(Collectors.toList());
    }

    @Override
    public IPrototypedIngredientAlternatives.ISerializer<?> getSerializer() {
        return SERIALIZER;
    }

    public boolean equals(Object obj) {
        return obj instanceof PrototypedIngredientAlternativesItemStackTag && this.keys.equals(((PrototypedIngredientAlternativesItemStackTag)obj).keys) && Objects.equals(this.matchCondition, ((PrototypedIngredientAlternativesItemStackTag)obj).matchCondition) && Objects.equals(this.quantity, ((PrototypedIngredientAlternativesItemStackTag)obj).quantity);
    }

    public int hashCode() {
        return 0x4D3 | this.keys.hashCode() << 2 | this.matchCondition | (int)this.quantity;
    }

    public long getQuantity() {
        return this.quantity;
    }

    public String toString() {
        return "[PrototypedIngredientAlternativesList: " + this.keys.toString() + "]";
    }

    static {
        SERIALIZERS.put((byte)1, (Object)SERIALIZER);
        CACHE_OREDICT = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Collection<Item>>(){

            public Collection<Item> load(String key) {
                return BuiltInRegistries.ITEM.getTag(TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)key))).map(named -> named.stream().map(Holder::value).collect(Collectors.toList())).orElse(Collections.emptyList());
            }
        });
    }

    public static class Serializer
    implements IPrototypedIngredientAlternatives.ISerializer<PrototypedIngredientAlternativesItemStackTag> {
        @Override
        public byte getId() {
            return 1;
        }

        @Override
        public <T, M> Tag serialize(HolderLookup.Provider lookupProvider, IngredientComponent<T, M> ingredientComponent, PrototypedIngredientAlternativesItemStackTag alternatives) {
            CompoundTag tag = new CompoundTag();
            ListTag keys = new ListTag();
            for (String key : alternatives.keys) {
                keys.add((Object)StringTag.valueOf((String)key));
            }
            tag.put("keys", (Tag)keys);
            tag.putInt("match", alternatives.matchCondition.intValue());
            tag.putLong("quantity", alternatives.quantity);
            return tag;
        }

        @Override
        public <T, M> PrototypedIngredientAlternativesItemStackTag deserialize(HolderLookup.Provider lookupProvider, IngredientComponent<T, M> ingredientComponent, Tag tag) {
            CompoundTag tagCompound = (CompoundTag)tag;
            if (!tagCompound.contains("keys")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain valid keys");
            }
            if (!tagCompound.contains("match")) {
                throw new IllegalArgumentException("A oredict prototyped alternatives did not contain a valid match");
            }
            ListTag keysTag = tagCompound.getList("keys", 8);
            ArrayList keys = Lists.newArrayList();
            for (Tag key : keysTag) {
                keys.add(key.getAsString());
            }
            int matchCondition = tagCompound.getInt("match");
            long quantity = tagCompound.getLong("quantity");
            return new PrototypedIngredientAlternativesItemStackTag(keys, matchCondition, quantity);
        }
    }
}

