/*
 * Decompiled with CFR 0.152.
 */
package net.commoble.jumbofurnace.recipes;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import net.commoble.jumbofurnace.JumboFurnace;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;

public record JumboFurnaceRecipe(String group, List<SizedIngredient> ingredients, List<ItemStack> results, float experience, int cookingTime, Supplier<Integer> specificity) implements Recipe<RecipeInput>
{
    public static final MapCodec<JumboFurnaceRecipe> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(JumboFurnaceRecipe::group), (App)SizedIngredient.FLAT_CODEC.listOf().comapFlatMap(JumboFurnaceRecipe::validateIngredients, Function.identity()).fieldOf("ingredients").forGetter(JumboFurnaceRecipe::ingredients), (App)ItemStack.CODEC.listOf().fieldOf("results").flatXmap(JumboFurnaceRecipe::readResults, JumboFurnaceRecipe::writeResults).forGetter(JumboFurnaceRecipe::results), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.0f)).forGetter(JumboFurnaceRecipe::experience), (App)Codec.INT.optionalFieldOf("cookingtime", (Object)200).forGetter(JumboFurnaceRecipe::cookingTime)).apply((Applicative)builder, JumboFurnaceRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, JumboFurnaceRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, JumboFurnaceRecipe::group, (StreamCodec)SizedIngredient.STREAM_CODEC.apply(ByteBufCodecs.list()), JumboFurnaceRecipe::ingredients, (StreamCodec)ItemStack.LIST_STREAM_CODEC, JumboFurnaceRecipe::results, (StreamCodec)ByteBufCodecs.FLOAT, JumboFurnaceRecipe::experience, (StreamCodec)ByteBufCodecs.VAR_INT, JumboFurnaceRecipe::cookingTime, JumboFurnaceRecipe::new);

    public JumboFurnaceRecipe(String group, List<SizedIngredient> ingredients, List<ItemStack> results, float experience, int cookingTime) {
        this(group, ingredients, results, experience, cookingTime, (Supplier<Integer>)Suppliers.memoize(() -> JumboFurnaceRecipe.getSpecificity(ingredients, experience)));
    }

    public JumboFurnaceRecipe(SmeltingRecipe baseRecipe) {
        this(baseRecipe.getGroup(), (List<SizedIngredient>)NonNullList.copyOf(baseRecipe.getIngredients().stream().map(ing -> new SizedIngredient(ing, 1)).toList()), List.of(baseRecipe.result.copy()), baseRecipe.getExperience(), baseRecipe.getCookingTime());
    }

    public static DataResult<List<SizedIngredient>> validateIngredients(List<SizedIngredient> ingredients) {
        int size = ingredients.size();
        if (size < 1) {
            return DataResult.error(() -> "No ingredients for jumbo smelting recipe");
        }
        if (size > 9) {
            return DataResult.error(() -> "Too many ingredients for jumbo smelting recipe! the max is 9");
        }
        return DataResult.success(ingredients);
    }

    public static DataResult<List<ItemStack>> readResults(List<ItemStack> list) {
        return list.isEmpty() ? DataResult.error(() -> "Empty result list for jumbo smelting recipe") : DataResult.success(list);
    }

    public static DataResult<List<ItemStack>> writeResults(List<ItemStack> results) {
        return results.isEmpty() ? DataResult.error(() -> "Empty result list for jumbo smelting recipe") : DataResult.success(results);
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.copyOf(this.ingredients().stream().map(SizedIngredient::ingredient).toList());
    }

    public boolean matches(RecipeInput inv, Level worldIn) {
        return false;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack assemble(RecipeInput input, HolderLookup.Provider registries) {
        return this.results.get(0).copy();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.results.get(0).copy();
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)JumboFurnace.get().jumboSmeltingRecipeSerializer.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)JumboFurnace.get().jumboSmeltingRecipeType.get();
    }

    public boolean isSpecial() {
        return true;
    }

    public static int getSpecificity(List<SizedIngredient> ingredients, float experience) {
        int specificity = (int)(experience * 10.0f);
        int totalItems = BuiltInRegistries.ITEM.size();
        for (SizedIngredient ingredient : ingredients) {
            ItemStack[] matchingStacks = ingredient.getItems();
            if (matchingStacks.length < 1) continue;
            int matchingItems = Math.min(totalItems, matchingStacks.length);
            double matchFactor = (double)(totalItems - matchingItems) / (double)(totalItems - 1);
            int ingredientWeight = (int)(100.0 * (double)matchingStacks[0].getCount() * matchFactor);
            specificity += ingredientWeight;
        }
        return specificity;
    }

    public NonNullList<ItemStack> getRemainingItems(RecipeInput inv) {
        return NonNullList.create();
    }
}

