/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.sts15.fargos.network.NetworkHandler;
import com.sts15.fargos.network.TalismanType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TalismanToggleScreen
extends Screen {
    public static final int WINDOW_WIDTH = 252;
    public static final int WINDOW_HEIGHT = 200;
    private static final int NODE_HEIGHT = 20;
    private static final int SCROLL_BAR_WIDTH = 10;
    private int leftPos;
    private int topPos;
    private int scrollOffset = 0;
    private boolean isScrolling = false;
    private List<TalismanNode> nodes;
    private int totalNodeHeight;
    private final Map<Integer, Boolean> talismanStates = new HashMap<Integer, Boolean>();
    private final Component headerText = Component.translatable((String)"screen.fargostalismans.header").withStyle(ChatFormatting.BOLD);

    public TalismanToggleScreen(Component title) {
        super(title);
    }

    protected void init() {
        this.leftPos = (this.width - 252) / 2;
        this.topPos = (this.height - 200) / 2;
        this.nodes = this.setupTalismanNodes();
        this.totalNodeHeight = this.nodes.size() * 20;
    }

    public void setTalismanStates(Map<Integer, Boolean> states) {
        this.talismanStates.clear();
        this.talismanStates.putAll(states);
        this.updateTalismanStates();
    }

    private List<TalismanNode> setupTalismanNodes() {
        ArrayList<TalismanNode> talismanNodes = new ArrayList<TalismanNode>();
        ArrayList<TalismanNode> soulNodes = new ArrayList<TalismanNode>();
        for (Map.Entry<Integer, Boolean> entry : this.talismanStates.entrySet()) {
            TalismanType talismanType = TalismanType.byIndex(entry.getKey());
            String talismanName = talismanType.name();
            boolean isEnabled = entry.getValue();
            if (talismanName.endsWith("_TALISMAN")) {
                talismanNodes.add(new TalismanNode(talismanName.toLowerCase(), isEnabled));
                continue;
            }
            if (!talismanName.startsWith("SOUL_OF_")) continue;
            soulNodes.add(new TalismanNode(talismanName.toLowerCase(), isEnabled));
        }
        ArrayList<TalismanNode> nodes = new ArrayList<TalismanNode>();
        if (!talismanNodes.isEmpty()) {
            nodes.add(new TalismanNode("talisman_header", false));
            nodes.addAll(talismanNodes);
        }
        if (!soulNodes.isEmpty()) {
            nodes.add(new TalismanNode("soul_header", false));
            nodes.addAll(soulNodes);
        }
        return nodes;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderCustomBackground(guiGraphics);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawHeader(guiGraphics);
        this.drawNodes(guiGraphics, mouseX, mouseY);
        this.drawScrollBar(guiGraphics);
    }

    private void renderCustomBackground(GuiGraphics guiGraphics) {
        int startColor = FastColor.ARGB32.color((int)200, (int)34, (int)45, (int)50);
        int endColor = FastColor.ARGB32.color((int)200, (int)24, (int)35, (int)40);
        guiGraphics.fillGradient(this.leftPos, this.topPos, this.leftPos + 252, this.topPos + 200, startColor, endColor);
        int overlayColor = FastColor.ARGB32.color((int)120, (int)20, (int)20, (int)20);
        guiGraphics.fill(this.leftPos + 10, this.topPos + 10, this.leftPos + 252 - 10, this.topPos + 200 - 10, overlayColor);
        int borderColor = FastColor.ARGB32.color((int)255, (int)80, (int)150, (int)200);
        guiGraphics.renderOutline(this.leftPos, this.topPos, 252, 200, borderColor);
    }

    private void drawHeaderNode(GuiGraphics guiGraphics, String nodeType, int x, int y, int mouseX, int mouseY) {
        int startColor = FastColor.ARGB32.color((int)240, (int)80, (int)80, (int)100);
        int endColor = FastColor.ARGB32.color((int)240, (int)60, (int)60, (int)80);
        int borderColor = FastColor.ARGB32.color((int)255, (int)160, (int)160, (int)220);
        guiGraphics.fillGradient(x, y, x + 200, y + 20 - 2, startColor, endColor);
        guiGraphics.renderOutline(x, y, 200, 18, borderColor);
        MutableComponent nameComponent = Component.translatable((String)("screen.fargostalismans.node." + nodeType + ".header")).withStyle(ChatFormatting.BOLD);
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)nameComponent, x + 25, y + 5, FastColor.ARGB32.color((int)255, (int)240, (int)240, (int)255), true);
    }

    private void drawNode(GuiGraphics guiGraphics, TalismanNode node, int x, int y, int mouseX, int mouseY) {
        if (node.talismanName().equals("talisman_header")) {
            this.drawHeaderNode(guiGraphics, "talisman", x, y, mouseX, mouseY);
            return;
        }
        if (node.talismanName().equals("soul_header")) {
            this.drawHeaderNode(guiGraphics, "soul", x, y, mouseX, mouseY);
            return;
        }
        int startColor = FastColor.ARGB32.color((int)220, (int)60, (int)60, (int)80);
        int endColor = FastColor.ARGB32.color((int)220, (int)40, (int)40, (int)60);
        int borderColor = FastColor.ARGB32.color((int)255, (int)140, (int)140, (int)180);
        int hoverColor = FastColor.ARGB32.color((int)255, (int)190, (int)190, (int)230);
        guiGraphics.fillGradient(x, y, x + 200, y + 20 - 2, startColor, endColor);
        int currentBorderColor = this.isHoveringNode(x, y, mouseX, mouseY) ? hoverColor : borderColor;
        guiGraphics.renderOutline(x, y, 200, 18, currentBorderColor);
        MutableComponent nameComponent = Component.translatable((String)("item.fargostalismans." + node.talismanName()));
        guiGraphics.drawString(Minecraft.getInstance().font, (Component)nameComponent, x + 25, y + 5, FastColor.ARGB32.color((int)255, (int)240, (int)240, (int)255), true);
        this.drawCheckbox(guiGraphics, x + 170, y + 5, node.enabled());
        this.drawIcon(guiGraphics, x + 5, y + 4 - 1, node);
        if (this.isHoveringNode(x, y, mouseX, mouseY)) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)Component.translatable((String)("item.fargostalismans.tooltip." + node.talismanName())), mouseX, mouseY);
        }
    }

    private void drawCheckbox(GuiGraphics guiGraphics, int x, int y, boolean checked) {
        int outlineColor = FastColor.ARGB32.color((int)255, (int)220, (int)220, (int)255);
        int checkmarkColor = FastColor.ARGB32.color((int)255, (int)50, (int)220, (int)80);
        guiGraphics.fill(x, y, x + 10, y + 10, outlineColor);
        if (checked) {
            guiGraphics.fill(x + 2, y + 2, x + 8, y + 8, checkmarkColor);
        }
    }

    private void drawHeader(GuiGraphics guiGraphics) {
        int headerX = this.leftPos + 126 - Minecraft.getInstance().font.width((FormattedText)this.headerText) / 2;
        int headerY = this.topPos + 5;
        guiGraphics.drawString(Minecraft.getInstance().font, this.headerText, headerX, headerY, FastColor.ARGB32.color((int)255, (int)255, (int)255, (int)255), true);
    }

    private void drawNodes(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int yStart = this.topPos + 20 - this.scrollOffset;
        for (int i = 0; i < this.nodes.size(); ++i) {
            TalismanNode node = this.nodes.get(i);
            int yPos = yStart + i * 20;
            if (yPos < this.topPos + 20 || yPos > this.topPos + 200 - 40) continue;
            this.drawNode(guiGraphics, node, this.leftPos + 20, yPos, mouseX, mouseY);
        }
    }

    private void drawIcon(GuiGraphics guiGraphics, int x, int y, TalismanNode node) {
        ResourceLocation iconLocation = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)("textures/item/" + node.talismanName() + ".png"));
        guiGraphics.blit(iconLocation, x, y, 0.0f, 0.0f, 12, 12, 12, 12);
    }

    public void updateTalismanStates() {
        this.nodes = this.setupTalismanNodes();
        if (this.nodes.isEmpty()) {
            // empty if block
        }
        this.totalNodeHeight = this.nodes.size() * 20;
        this.init();
    }

    private boolean isHoveringNode(int x, int y, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && mouseX < x + 200 && mouseY < y + 20;
    }

    private void drawScrollBar(GuiGraphics guiGraphics) {
        int visibleHeight = 160;
        if (this.totalNodeHeight == 0) {
            return;
        }
        int maxScrollOffset = Math.max(0, this.totalNodeHeight - visibleHeight);
        int scrollBarHeight = Math.max(10, visibleHeight * visibleHeight / this.totalNodeHeight);
        if (maxScrollOffset > 0) {
            int scrollBarY = this.topPos + 20 + (int)((float)this.scrollOffset / (float)maxScrollOffset * (float)(visibleHeight - scrollBarHeight));
            guiGraphics.fill(this.leftPos + 252 - 10, scrollBarY, this.leftPos + 252, scrollBarY + scrollBarHeight, FastColor.ARGB32.color((int)255, (int)128, (int)128, (int)128));
        } else {
            guiGraphics.fill(this.leftPos + 252 - 10, this.topPos + 20, this.leftPos + 252, this.topPos + 20 + scrollBarHeight, FastColor.ARGB32.color((int)255, (int)128, (int)128, (int)128));
        }
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int visibleHeight = 160;
            int scrollBarHeight = Math.max(10, visibleHeight * visibleHeight / this.totalNodeHeight);
            int maxScrollOffset = Math.max(0, this.totalNodeHeight - visibleHeight);
            double scrollBarY = Mth.clamp((double)(mouseY - (double)this.topPos - 20.0 - (double)scrollBarHeight / 2.0), (double)0.0, (double)(visibleHeight - scrollBarHeight));
            this.scrollOffset = (int)Mth.clamp((double)(scrollBarY / (double)(visibleHeight - scrollBarHeight) * (double)maxScrollOffset), (double)0.0, (double)maxScrollOffset);
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.isHovering(this.leftPos + 252 - 10, this.topPos + 20, 10, 180, (int)mouseX, (int)mouseY)) {
            this.isScrolling = true;
        } else {
            for (int i = 0; i < this.nodes.size(); ++i) {
                int yStart = this.topPos + 20 - this.scrollOffset;
                int yPos = yStart + i * 20;
                TalismanNode node = this.nodes.get(i);
                if (node.talismanName().equals("talisman_header") || node.talismanName().equals("soul_header")) continue;
                int checkboxX = this.leftPos + 180;
                int checkboxY = yPos + 5;
                if (this.isHovering(checkboxX, checkboxY, 10, 10, (int)mouseX, (int)mouseY)) {
                    this.toggleTalisman(node);
                    return true;
                }
                if (!this.isHoveringNode(this.leftPos + 20, yPos, (int)mouseX, (int)mouseY)) continue;
                this.toggleTalisman(node);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void toggleTalisman(TalismanNode node) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            TalismanType talismanType = TalismanType.valueOf(node.talismanName().toUpperCase());
            boolean isEnabled = this.talismanStates.get(talismanType.getIndex()) == false;
            this.talismanStates.put(talismanType.getIndex(), isEnabled);
            this.nodes.set(this.nodes.indexOf(node), new TalismanNode(node.talismanName(), isEnabled));
            NetworkHandler.sendToggleTalismanStateToLocal(talismanType.getIndex(), isEnabled);
            this.updateTalismanStates();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseY >= y && mouseX < x + width && mouseY < y + height;
    }

    public static void open() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null) {
            minecraft.execute(() -> {
                NetworkHandler.sendTalismanStateRequestToServer();
                minecraft.setScreen((Screen)new TalismanToggleScreen((Component)Component.literal((String)"Talisman Toggle")));
            });
        }
    }

    record TalismanNode(String talismanName, boolean enabled) {
    }
}

