/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.network.packet;

import com.sts15.fargos.config.PlayerDataHandler;
import com.sts15.fargos.network.TalismanType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ToggleTalismanStatePacket
implements CustomPacketPayload {
    private final int talismanIndex;
    private final boolean isEnabled;
    public static final CustomPacketPayload.Type<ToggleTalismanStatePacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"toggle_talisman_state"));
    public static final StreamCodec<FriendlyByteBuf, ToggleTalismanStatePacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ToggleTalismanStatePacket::getTalismanIndex, (StreamCodec)ByteBufCodecs.BOOL, ToggleTalismanStatePacket::isEnabled, ToggleTalismanStatePacket::new);

    public ToggleTalismanStatePacket(int talismanIndex, boolean isEnabled) {
        this.talismanIndex = talismanIndex;
        this.isEnabled = isEnabled;
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    private Integer getTalismanIndex() {
        return this.talismanIndex;
    }

    private Boolean isEnabled() {
        return this.isEnabled;
    }

    public static void handle(ToggleTalismanStatePacket packet, IPayloadContext context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            int talismanIndex = packet.talismanIndex;
            boolean isEnabled = packet.isEnabled;
            TalismanType talismanType = TalismanType.byIndex(talismanIndex);
            PlayerDataHandler.setTalismanState(player2, talismanType.name(), isEnabled);
        }
    }
}

