/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.network;

import com.sts15.fargos.network.packet.ServerTalismanConfigPacket;
import com.sts15.fargos.network.packet.SyncAirStatusPacket;
import com.sts15.fargos.network.packet.TalismanStatePacket;
import com.sts15.fargos.network.packet.ToggleTalismanStatePacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public class NetworkHandler {
    public static void registerPackets(@NotNull RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("fargostalismans").versioned("1.0").optional();
        registrar.playToServer(ToggleTalismanStatePacket.TYPE, ToggleTalismanStatePacket.STREAM_CODEC, ToggleTalismanStatePacket::handle);
        registrar.playToClient(SyncAirStatusPacket.TYPE, SyncAirStatusPacket.STREAM_CODEC, SyncAirStatusPacket::handle);
        registrar.playBidirectional(TalismanStatePacket.TYPE, TalismanStatePacket.STREAM_CODEC, TalismanStatePacket::handle);
        registrar.playBidirectional(ServerTalismanConfigPacket.TYPE, ServerTalismanConfigPacket.STREAM_CODEC, ServerTalismanConfigPacket::handle);
    }

    public static void sendToggleTalismanStateToServer(int talismanIndex, boolean isEnabled) {
        ToggleTalismanStatePacket packet = new ToggleTalismanStatePacket(talismanIndex, isEnabled);
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendToggleTalismanStateToLocal(int talismanIndex, boolean isEnabled) {
        ToggleTalismanStatePacket packet = new ToggleTalismanStatePacket(talismanIndex, isEnabled);
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendSyncAirStatusToClient(ServerPlayer player, int air) {
        SyncAirStatusPacket packet = new SyncAirStatusPacket(air);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTalismanStateRequestToServer() {
        TalismanStatePacket packet = new TalismanStatePacket(new HashMap<Integer, Boolean>());
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendTalismanStateToClient(ServerPlayer player, Map<Integer, Boolean> talismanStates) {
        TalismanStatePacket packet = new TalismanStatePacket(talismanStates);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendServerTalismanConfigRequestToServer(LocalPlayer localPlayer) {
        ServerTalismanConfigPacket packet = new ServerTalismanConfigPacket(localPlayer.getUUID().toString(), new HashMap<String, Boolean>());
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendServerTalismanConfigToClient(ServerPlayer serverPlayer, UUID playerUUID, Map<String, Boolean> talismanStates) {
        ServerTalismanConfigPacket packet = new ServerTalismanConfigPacket(playerUUID.toString(), talismanStates);
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

