/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Shulker_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ShulkerBullet;
import net.minecraft.world.phys.EntityHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(value={ShulkerBullet.class})
public class ShulkerMixin {
    @Inject(method={"onHitEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHitEntity(EntityHitResult result, CallbackInfo ci) {
        Player player;
        Entity entity = result.getEntity();
        if (entity instanceof Player && ShulkerMixin.hasShulkerTalisman(player = (Player)entity)) {
            DamageSource DamageS = player.level().damageSources().generic();
            entity.hurt(DamageS, 4.0f);
            ci.cancel();
        }
    }

    private static boolean hasShulkerTalisman(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TalismanUtil.isTalismanEnabled(serverPlayer, "shulker_talisman")) {
                return false;
            }
            return player.hasEffect(EffectsInit.SHULKER_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Shulker_Talisman_Provider, (LivingEntity)serverPlayer).isPresent();
        }
        return false;
    }
}

