/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.mixins;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.items.providers.Spectral_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import top.theillusivec4.curios.api.CuriosApi;

@Mixin(targets={"net.minecraft.world.entity.monster.Phantom$PhantomAttackPlayerTargetGoal"})
public abstract class PhantomAttackPlayerTargetGoalMixin {
    @Shadow
    @Final
    Phantom this$0;

    @Inject(method={"canUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanUse(CallbackInfoReturnable<Boolean> cir) {
        List players = this.this$0.level().getNearbyPlayers(TargetingConditions.forCombat().range(64.0), (LivingEntity)this.this$0, this.this$0.getBoundingBox().inflate(16.0, 64.0, 16.0));
        for (Player player : players) {
            if (!PhantomAttackPlayerTargetGoalMixin.hasPhantomTalisman(player)) continue;
            cir.setReturnValue((Object)false);
            return;
        }
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCanContinueToUse(CallbackInfoReturnable<Boolean> cir) {
        Player player;
        LivingEntity target = this.this$0.getTarget();
        if (target instanceof Player && PhantomAttackPlayerTargetGoalMixin.hasPhantomTalisman(player = (Player)target)) {
            cir.setReturnValue((Object)false);
        }
    }

    private static boolean hasPhantomTalisman(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!TalismanUtil.isTalismanEnabled(serverPlayer, "spectral_talisman")) {
                return false;
            }
            return player.hasEffect(EffectsInit.SPECTRAL_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(itemStack -> itemStack.getItem() instanceof Spectral_Talisman_Provider, (LivingEntity)serverPlayer).isPresent();
        }
        return false;
    }
}

