/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Vindicator_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Vindicator_Talisman
extends TalismanItem
implements Vindicator_Talisman_Provider {
    private static final String talismanName = "vindicator_talisman";
    private static final Map<UUID, ItemStack> lastHeldItems = new HashMap<UUID, ItemStack>();
    private static final Map<UUID, Long> lastWeaponSwitchTimes = new HashMap<UUID, Long>();
    private static final Map<UUID, Boolean> canBoostAttack = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Long> lastBoostTimes = new HashMap<UUID, Long>();

    public Vindicator_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.vindicator_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Vindicator_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    private static void trackWeaponSwitch(Player player, UUID playerId) {
        ItemStack currentItem = player.getMainHandItem();
        long currentTime = player.level().getGameTime();
        if (!lastHeldItems.containsKey(playerId) || !ItemStack.matches((ItemStack)currentItem, (ItemStack)lastHeldItems.get(playerId))) {
            lastHeldItems.put(playerId, currentItem.copy());
            lastWeaponSwitchTimes.put(playerId, currentTime);
            if (!lastBoostTimes.containsKey(playerId) || currentTime - lastBoostTimes.get(playerId) > (long)Config.VINDICATOR_TALISMAN_BOOST_COOLDOWN.getAsInt()) {
                canBoostAttack.put(playerId, true);
            }
        }
    }

    private static void applyVindicatorBoostIfEligible(Player attacker, LivingDamageEvent.Pre event) {
        UUID attackerId = attacker.getUUID();
        long currentTime = attacker.level().getGameTime();
        if (canBoostAttack.getOrDefault(attackerId, false).booleanValue() && Vindicator_Talisman.isEligibleForVindicatorBoost(attackerId, currentTime)) {
            float boostedDamage = event.getOriginalDamage() * (1.0f + ((Double)Config.VINDICATOR_TALISMAN_BOOST_DAMAGE_MODIFIER.get()).floatValue());
            event.setNewDamage(boostedDamage);
            canBoostAttack.put(attackerId, false);
            lastBoostTimes.put(attackerId, currentTime);
        }
    }

    private static boolean isEligibleForVindicatorBoost(UUID playerId, long currentTime) {
        Long lastSwitchTime = lastWeaponSwitchTimes.get(playerId);
        boolean isEligible = lastSwitchTime != null && currentTime - lastSwitchTime <= (long)Config.VINDICATOR_TALISMAN_WEAPON_SWAP_TIME.getAsInt();
        return isEligible;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            UUID playerUUID = player2.getUUID();
            if (player2.hasEffect(EffectsInit.VINDICATOR_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Vindicator_Talisman_Provider, (LivingEntity)player2).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player2, Vindicator_Talisman.talismanName)) {
                    return;
                }
                Vindicator_Talisman.trackWeaponSwitch((Player)player2, playerUUID);
            }
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingDamageEvent.Pre event) {
            Entity entity = event.getSource().getEntity();
            if (!(entity instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)entity;
            if (player.hasEffect(EffectsInit.VINDICATOR_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Vindicator_Talisman_Provider, (LivingEntity)player).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player, Vindicator_Talisman.talismanName)) {
                    return;
                }
                Vindicator_Talisman.applyVindicatorBoostIfEligible((Player)player, event);
            }
        }
    }
}

