/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Rain_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Rain_Talisman
extends TalismanItem
implements Rain_Talisman_Provider {
    private static final String talismanName = "rain_talisman";
    private static final ResourceLocation RAIN_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"rain_talisman_speed_modifier");

    public Rain_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        double configValue = Config.RAIN_TALISMAN_INCREASED_SPEED.getAsDouble() * 100.0;
        String formattedReduction = configValue == (double)((int)configValue) ? String.format("%.0f", configValue) : String.format("%.1f", configValue);
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.rain_talisman", (Object[])new Object[]{formattedReduction}).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Rain_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            boolean hasTalismanEquipped;
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            Level level = player2.level();
            AttributeInstance movementAttribute = player2.getAttribute(Attributes.MOVEMENT_SPEED);
            if (movementAttribute == null) {
                return;
            }
            boolean isRaining = level.isRaining();
            boolean isInWater = player2.isInWater();
            boolean bl = hasTalismanEquipped = player2.hasEffect(EffectsInit.RAIN_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Rain_Talisman_Provider, (LivingEntity)player2).isPresent();
            if (isRaining && isInWater && hasTalismanEquipped) {
                if (!TalismanUtil.isTalismanEnabled(player2, Rain_Talisman.talismanName)) {
                    return;
                }
                if (!movementAttribute.hasModifier(RAIN_SPEED_MODIFIER_ID)) {
                    AttributeModifier speedModifier = new AttributeModifier(RAIN_SPEED_MODIFIER_ID, Config.RAIN_TALISMAN_INCREASED_SPEED.getAsDouble(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
                    movementAttribute.addTransientModifier(speedModifier);
                }
            } else if (movementAttribute.hasModifier(RAIN_SPEED_MODIFIER_ID)) {
                movementAttribute.removeModifier(RAIN_SPEED_MODIFIER_ID);
            }
        }
    }
}

