/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Pickaxe_Talisman
extends TalismanItem {
    private static final String talismanName = "pickaxe_talisman";
    private static final Map<UUID, AttributeModifier> miningSpeedModifiers = new HashMap<UUID, AttributeModifier>();
    private static final ResourceLocation PICKAXE_MINING_SPEED_BOOST_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"pickaxe_mining_speed_boost");

    public Pickaxe_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.pickaxe_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Pickaxe_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    private static void resetMiningSpeed(Player player, UUID playerId) {
        AttributeInstance miningSpeedAttribute = player.getAttribute(Attributes.BLOCK_BREAK_SPEED);
        if (miningSpeedAttribute != null && miningSpeedModifiers.containsKey(playerId)) {
            miningSpeedAttribute.removeModifier(miningSpeedModifiers.get(playerId));
            miningSpeedModifiers.remove(playerId);
        }
    }

    private static void increaseMiningSpeed(Player player, UUID playerId) {
        AttributeInstance miningSpeedAttribute = player.getAttribute(Attributes.BLOCK_BREAK_SPEED);
        if (miningSpeedAttribute != null && !miningSpeedModifiers.containsKey(playerId)) {
            AttributeModifier modifier = new AttributeModifier(PICKAXE_MINING_SPEED_BOOST_ID, Config.PICKAXE_TALISMAN_MINING_SPEED_MULTIPLIER.getAsDouble(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
            miningSpeedAttribute.addTransientModifier(modifier);
            miningSpeedModifiers.put(playerId, modifier);
        }
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (++tickCounter < 10) {
                return;
            }
            tickCounter = 0;
            UUID playerUUID = player2.getUUID();
            if (!TalismanUtil.isTalismanEnabled(player2, Pickaxe_Talisman.talismanName)) {
                Pickaxe_Talisman.resetMiningSpeed((Player)player2, playerUUID);
            }
            if (player2.hasEffect(EffectsInit.PICKAXE_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Pickaxe_Talisman, (LivingEntity)player2).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player2, Pickaxe_Talisman.talismanName)) {
                    return;
                }
                Pickaxe_Talisman.increaseMiningSpeed((Player)player2, playerUUID);
            } else {
                Pickaxe_Talisman.resetMiningSpeed((Player)player2, playerUUID);
            }
        }
    }
}

