/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Lapis_Talisman
extends TalismanItem {
    private static final String talismanName = "lapis_talisman";

    public Lapis_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.lapis_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Lapis_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            ServerPlayer player;
            Player player2 = event.getEntity();
            if (player2 instanceof ServerPlayer && ((player = (ServerPlayer)player2).hasEffect(EffectsInit.LAPIS_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Lapis_Talisman, (LivingEntity)player).isPresent())) {
                if (!TalismanUtil.isTalismanEnabled(player, Lapis_Talisman.talismanName)) {
                    return;
                }
                Events.attractXPOrbs((Player)player);
            }
        }

        private static void attractXPOrbs(Player player) {
            Level level = player.level();
            AABB area = player.getBoundingBox().inflate((double)Config.LAPIS_TALISMAN_PICKUP_RANGE.getAsInt());
            List xpOrbs = level.getEntitiesOfClass(ExperienceOrb.class, area);
            for (ExperienceOrb xpOrb : xpOrbs) {
                double zDir;
                double yDir;
                if (!xpOrb.isAlive()) continue;
                double speed = Config.LAPIS_TALISMAN_SPEED.getAsDouble();
                double xDir = player.getX() - xpOrb.getX();
                double distance = Math.sqrt(xDir * xDir + (yDir = player.getY() - xpOrb.getY()) * yDir + (zDir = player.getZ() - xpOrb.getZ()) * zDir);
                if (distance < 1.0) {
                    xpOrb.teleportTo(player.getX(), player.getY(), player.getZ());
                    xpOrb.playerTouch(player);
                    continue;
                }
                xpOrb.setDeltaMovement(xpOrb.getDeltaMovement().add(xDir / distance * speed, yDir / distance * speed, zDir / distance * speed));
            }
        }
    }
}

