/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Ghast_Talisman_Provider;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class Ghast_Talisman
extends TalismanItem
implements Ghast_Talisman_Provider {
    private static final String talismanName = "ghast_talisman";

    public Ghast_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.ghast_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Ghast_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static final double DETECTION_RADIUS = 7.0;
        private static final String REDIRECTED_TAG = "RedirectedByPlayer";

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof Player)) {
                return;
            }
            Player player2 = player;
            Level level = player2.level();
            if (level.isClientSide() || !(level instanceof ServerLevel)) {
                return;
            }
            List nearbyFireballs = level.getEntitiesOfClass(LargeFireball.class, player2.getBoundingBox().inflate(7.0));
            for (LargeFireball fireball : nearbyFireballs) {
                Entity ghastSource = Events.findNearestGhast(level, (Entity)fireball);
                if (!(ghastSource instanceof Ghast)) continue;
                Events.redirectFireballTowardGhast(fireball, ghastSource, player2);
            }
        }

        private static Entity findNearestGhast(Level level, Entity fireball) {
            double searchRadius = 64.0;
            AABB searchBox = fireball.getBoundingBox().inflate(searchRadius);
            List nearbyGhasts = level.getEntitiesOfClass(Ghast.class, searchBox);
            Ghast closestGhast = null;
            double closestDistance = Double.MAX_VALUE;
            for (Ghast ghast : nearbyGhasts) {
                double distance = ghast.distanceTo(fireball);
                if (!(distance < closestDistance)) continue;
                closestDistance = distance;
                closestGhast = ghast;
            }
            return closestGhast;
        }

        public static void redirectFireballTowardGhast(LargeFireball fireball, Entity targetGhast, Player player) {
            CompoundTag tag = fireball.getPersistentData();
            if (tag.getBoolean(REDIRECTED_TAG)) {
                return;
            }
            tag.putBoolean(REDIRECTED_TAG, true);
            Vec3 fireballPos = fireball.position();
            Vec3 ghastPos = targetGhast.position();
            Vec3 direction = ghastPos.subtract(fireballPos).normalize().scale(0.1);
            fireball.setDeltaMovement(direction.x, direction.y, direction.z);
            fireball.setOwner((Entity)player);
            fireball.level().playSound(null, player.blockPosition(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }
}

