/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.talismans;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Enchanting_Talisman_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Enchanting_Talisman
extends TalismanItem
implements Enchanting_Talisman_Provider {
    private static final String talismanName = "enchanting_talisman";

    public Enchanting_Talisman() {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.enchanting_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Enchanting_Talisman.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                if (++tickCounter < 10) {
                    return;
                }
                tickCounter = 0;
                if (player2.hasEffect(EffectsInit.ENCHANTING_TALISMAN_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Enchanting_Talisman_Provider, (LivingEntity)player2).isPresent()) {
                    if (!TalismanUtil.isTalismanEnabled(player2, Enchanting_Talisman.talismanName)) {
                        return;
                    }
                    Events.removeCurses(player2.getMainHandItem(), player2);
                    Events.removeCurses(player2.getOffhandItem(), player2);
                }
            }
        }

        public static void removeCurses(ItemStack itemStack, ServerPlayer player) {
            if (itemStack != null && !itemStack.isEmpty()) {
                ItemEnchantments itemEnchantments = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)itemStack);
                ItemEnchantments.Mutable mutableEnchantments = new ItemEnchantments.Mutable(itemEnchantments);
                Set enchantments = itemEnchantments.keySet();
                List<Holder> cursesToRemove = enchantments.stream().filter(enchantment -> enchantment.is(EnchantmentTags.CURSE)).toList();
                if (!cursesToRemove.isEmpty()) {
                    mutableEnchantments.removeIf(enchantment -> enchantment.is(EnchantmentTags.CURSE));
                    ItemEnchantments updatedEnchantments = mutableEnchantments.toImmutable();
                    EnchantmentHelper.setEnchantments((ItemStack)itemStack, (ItemEnchantments)updatedEnchantments);
                    for (Holder curse : cursesToRemove) {
                        MutableComponent message = Component.literal((String)"[").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN)).append((Component)Component.translatable((String)"item.fargostalismans.enchanting_talisman").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN))).append((Component)Component.literal((String)"] ").setStyle(Style.EMPTY.withColor(ChatFormatting.GREEN))).append((Component)Component.translatable((String)((Enchantment)curse.value()).description().getString()).setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)" removed from ").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE))).append((Component)Component.literal((String)itemStack.getHoverName().getString()).setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE)));
                        player.sendSystemMessage((Component)message);
                    }
                }
            }
        }
    }
}

