/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.souls;

import com.sts15.fargos.effect.EffectsInit;
import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Soul_of_Supersonic_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;

public class Soul_of_Supersonic
extends TalismanItem
implements Soul_of_Supersonic_Provider {
    private static final ResourceLocation WALK_SPEED_MODIFIER_ID = ResourceLocation.fromNamespaceAndPath((String)"fargos", (String)"supersonic_walking_speed_boost");
    public static final String talismanName = "soul_of_supersonic";

    public Soul_of_Supersonic() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    private static double getWalkSpeedBoost() {
        return (Double)Config.SOUL_OF_SUPERSONIC_WALK_SPEED_MULTIPLIER.get();
    }

    private static double getFlySpeedBoost() {
        return (Double)Config.SOUL_OF_SUPERSONIC_FLY_SPEED_MULTIPLIER.get();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.soul_of_supersonic").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Soul_of_Supersonic.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    private static void applyEffects(Player player, CompoundTag playerData) {
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && speedAttribute.getModifier(WALK_SPEED_MODIFIER_ID) == null) {
            AttributeModifier modifier = new AttributeModifier(WALK_SPEED_MODIFIER_ID, Soul_of_Supersonic.getWalkSpeedBoost(), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            speedAttribute.addTransientModifier(modifier);
        }
        if (!playerData.getBoolean("SoulOfSupersonicFlyingSpeedBoost")) {
            player.getAbilities().setFlyingSpeed((float)((double)player.getAbilities().getFlyingSpeed() * Soul_of_Supersonic.getFlySpeedBoost()));
            playerData.putBoolean("SoulOfSupersonicFlyingSpeedBoost", true);
        }
        playerData.putBoolean("SoulOfSupersonicActive", true);
        player.onUpdateAbilities();
        player.sendSystemMessage((Component)Component.literal((String)"[").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)).append((Component)Component.translatable((String)"item.fargostalismans.soul_of_supersonic").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).append((Component)Component.literal((String)"] ").setStyle(Style.EMPTY.withColor(ChatFormatting.RED))).append((Component)Component.translatable((String)"key.categories.fargostalismans.fov").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE))));
    }

    private static void removeEffects(Player player, CompoundTag playerData) {
        AttributeModifier modifier;
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && (modifier = speedAttribute.getModifier(WALK_SPEED_MODIFIER_ID)) != null) {
            speedAttribute.removeModifier(modifier);
        }
        if (playerData.getBoolean("SoulOfSupersonicFlyingSpeedBoost")) {
            double flySpeedBoost = Soul_of_Supersonic.getFlySpeedBoost();
            player.getAbilities().setFlyingSpeed((float)((double)player.getAbilities().getFlyingSpeed() / flySpeedBoost));
            playerData.remove("SoulOfSupersonicFlyingSpeedBoost");
        }
        playerData.remove("SoulOfSupersonicActive");
        player.onUpdateAbilities();
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (++tickCounter < 10) {
                return;
            }
            tickCounter = 0;
            if (!TalismanUtil.isTalismanEnabled(player2, "Soul_of_Supersonic")) {
                Soul_of_Supersonic.removeEffects((Player)player2, player2.getPersistentData());
            } else if (player2.hasEffect(EffectsInit.SOUL_OF_SUPERSONIC_EFFECT) || CuriosApi.getCuriosHelper().findEquippedCurio(stack -> stack.getItem() instanceof Soul_of_Supersonic_Provider, (LivingEntity)player2).isPresent()) {
                if (!TalismanUtil.isTalismanEnabled(player2, "Soul_of_Supersonic")) {
                    return;
                }
                if (!player2.getPersistentData().getBoolean("SoulOfSupersonicActive")) {
                    Soul_of_Supersonic.applyEffects((Player)player2, player2.getPersistentData());
                }
            } else if (player2.getPersistentData().getBoolean("SoulOfSupersonicActive")) {
                Soul_of_Supersonic.removeEffects((Player)player2, player2.getPersistentData());
            }
        }
    }
}

