/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.items.souls;

import com.sts15.fargos.init.Config;
import com.sts15.fargos.items.TalismanItem;
import com.sts15.fargos.items.providers.Soul_of_Flight_Mastery_Provider;
import com.sts15.fargos.utils.TalismanUtil;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;

public class Soul_of_Flight_Mastery
extends TalismanItem
implements Soul_of_Flight_Mastery_Provider {
    public static final String talismanName = "soul_of_flight_mastery";
    private static final ResourceLocation FLIGHT_ENABLE_ID = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"soul_of_flight_mastery_enabled");

    public Soul_of_Flight_Mastery() {
        super(new Item.Properties().rarity(Rarity.EPIC));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"item.fargostalismans.tooltip.soul_of_flight_mastery").setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY)));
        if (!Soul_of_Flight_Mastery.checkConfigEnabledStatus()) {
            tooltipComponents.add((Component)Component.translatable((String)"config.fargostalismans.tooltip.disabled").setStyle(Style.EMPTY.withColor(ChatFormatting.RED)));
        }
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static boolean checkConfigEnabledStatus() {
        boolean isEnabled = true;
        try {
            String fieldName = talismanName.toUpperCase() + "_TOGGLE";
            Field toggleField = Config.class.getField(fieldName);
            isEnabled = (Boolean)((ModConfigSpec.BooleanValue)toggleField.get(null)).get();
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return isEnabled;
    }

    public static void enableFlight(Player player) {
        AttributeInstance flightAttribute = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (flightAttribute != null && flightAttribute.getBaseValue() == 0.0 && !player.isCreative() && !player.isSpectator()) {
            flightAttribute.setBaseValue(1.0);
            player.getPersistentData().putBoolean(FLIGHT_ENABLE_ID.toString(), true);
        }
    }

    public static void disableFlight(Player player) {
        AttributeInstance flightAttribute = player.getAttribute(NeoForgeMod.CREATIVE_FLIGHT);
        if (flightAttribute != null && flightAttribute.getBaseValue() == 1.0 && !player.isCreative() && !player.isSpectator()) {
            flightAttribute.setBaseValue(0.0);
            player.getAbilities().flying = false;
            player.getAbilities().mayfly = false;
            player.onUpdateAbilities();
            player.getPersistentData().remove(FLIGHT_ENABLE_ID.toString());
        }
    }

    private static boolean isFlightEnabledByMod(Player player) {
        return player.getPersistentData().getBoolean(FLIGHT_ENABLE_ID.toString());
    }

    @Override
    public void onEquip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        if (TalismanUtil.isTalismanEnabled(entity, talismanName)) {
            Soul_of_Flight_Mastery.enableFlight(entity);
        }
    }

    @Override
    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.getItem() == newStack.getItem()) {
            return;
        }
        Player entity = (Player)slotContext.entity();
        Soul_of_Flight_Mastery.disableFlight(entity);
    }

    @EventBusSubscriber(modid="fargostalismans")
    public static class Events {
        private static int tickCounter = 0;

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Pre event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player2 = (ServerPlayer)player;
            if (++tickCounter < 10) {
                return;
            }
            tickCounter = 0;
            boolean hasEquippedCurio = CuriosApi.getCuriosHelper().findEquippedCurio(equippedStack -> equippedStack.getItem() instanceof Soul_of_Flight_Mastery_Provider, (LivingEntity)player2).isPresent();
            if (hasEquippedCurio) {
                if (TalismanUtil.isTalismanEnabled(player2, Soul_of_Flight_Mastery.talismanName)) {
                    Soul_of_Flight_Mastery.enableFlight((Player)player2);
                } else if (Soul_of_Flight_Mastery.isFlightEnabledByMod((Player)player2)) {
                    Soul_of_Flight_Mastery.disableFlight((Player)player2);
                }
            }
        }
    }
}

