/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.events;

import com.sts15.fargos.items.ItemInit;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@EventBusSubscriber(modid="fargostalismans")
public class LootDropHandler {
    private static final List<Supplier<? extends Item>> CUSTOM_ITEMS = Arrays.asList(ItemInit.FLYING_CARPET, ItemInit.SWEETHEART_NECKLACE, ItemInit.AMBER_HORSESHOE_BALLOON, ItemInit.BUNDLE_OF_HORSESHOE_BALLOONS, ItemInit.SHIELD_OF_CTHULHU, ItemInit.MASTER_NINJA_GEAR, ItemInit.BLESSED_APPLE, ItemInit.MECHANICAL_CART, ItemInit.ANCIENT_HORN, ItemInit.REINDEER_BELLS, ItemInit.BRAIN_SCRAMBLER, ItemInit.AEOLUS_BOOTS);
    private static final Random RANDOM = new Random();

    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Level world = event.getEntity().level();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (LootDropHandler.isTargetMob(event.getEntity().getType())) {
                ItemStack loot;
                BlockPos entityPos = event.getEntity().blockPosition();
                ResourceLocation customStructureLocation = ResourceLocation.fromNamespaceAndPath((String)"fargostalismans", (String)"dungeon2");
                Registry structureRegistry = serverLevel.registryAccess().registryOrThrow(Registries.STRUCTURE);
                Structure customStructure = (Structure)structureRegistry.get(customStructureLocation);
                if (customStructure != null && serverLevel.structureManager().getStructureAt(entityPos, customStructure).isValid() && LootDropHandler.shouldDropLoot(player) && !(loot = LootDropHandler.getRandomCustomItem()).isEmpty()) {
                    event.getEntity().spawnAtLocation(loot);
                }
            }
        }
    }

    private static boolean isTargetMob(EntityType<?> entityType) {
        return entityType == EntityType.PIGLIN || entityType == EntityType.PIGLIN_BRUTE || entityType == EntityType.MAGMA_CUBE || entityType == EntityType.WITHER_SKELETON;
    }

    private static boolean shouldDropLoot(Player player) {
        Registry enchantmentRegistry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder.Reference lootingEnchantment = enchantmentRegistry.getHolderOrThrow(Enchantments.LOOTING);
        int lootingLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lootingEnchantment, (ItemStack)player.getMainHandItem());
        double chance = 0.05 + (double)lootingLevel * 0.02;
        return RANDOM.nextDouble() < chance;
    }

    private static ItemStack getRandomCustomItem() {
        Supplier<? extends Item> randomItemSupplier = CUSTOM_ITEMS.get(RANDOM.nextInt(CUSTOM_ITEMS.size()));
        return new ItemStack((ItemLike)randomItemSupplier.get());
    }
}

