/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.config;

import com.sts15.fargos.network.NetworkHandler;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ServerDataHandler {
    private static final String SERVER_TALISMAN_DATA_KEY = "ServerTalismanData";
    private static final Map<String, Boolean> serverTalismanStates = new HashMap<String, Boolean>();
    private static boolean requestSent = false;

    public static boolean isTalismanEnabledOnServer(String talismanName, LocalPlayer localPlayer) {
        if (serverTalismanStates.isEmpty() && !requestSent) {
            System.out.println("Server data is empty, requesting server talisman states...");
            requestSent = true;
            NetworkHandler.sendServerTalismanConfigRequestToServer(localPlayer);
            return true;
        }
        return serverTalismanStates.getOrDefault(talismanName, true);
    }

    public static void setServerTalismanStates(Map<String, Boolean> talismanStates) {
        serverTalismanStates.clear();
        serverTalismanStates.putAll(talismanStates);
        System.out.println("Server talisman states updated on client: " + String.valueOf(serverTalismanStates));
        requestSent = false;
    }

    public static void saveServerTalismanStatesToPlayer(LocalPlayer player) {
        CompoundTag data = player.getPersistentData().getCompound("PlayerPersisted");
        CompoundTag serverTalismanData = new CompoundTag();
        for (Map.Entry<String, Boolean> entry : serverTalismanStates.entrySet()) {
            serverTalismanData.putBoolean(entry.getKey(), entry.getValue().booleanValue());
        }
        data.put(SERVER_TALISMAN_DATA_KEY, (Tag)serverTalismanData);
        player.getPersistentData().put("PlayerPersisted", (Tag)data);
    }

    public static void loadServerTalismanStatesFromPlayer(LocalPlayer player) {
        CompoundTag data = player.getPersistentData().getCompound("PlayerPersisted");
        CompoundTag serverTalismanData = data.getCompound(SERVER_TALISMAN_DATA_KEY);
        serverTalismanStates.clear();
        for (String key : serverTalismanData.getAllKeys()) {
            serverTalismanStates.put(key, serverTalismanData.getBoolean(key));
        }
        System.out.println("Loaded server talisman states from player NBT: " + String.valueOf(serverTalismanStates));
    }
}

