/*
 * Decompiled with CFR 0.152.
 */
package com.sts15.fargos.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.sts15.fargos.network.TalismanType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig {
    private static final ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
    public static final Map<String, ModConfigSpec.BooleanValue> SERVER_TALISMAN_TOGGLES = new HashMap<String, ModConfigSpec.BooleanValue>();
    public static final Map<String, Boolean> talismanEnabledStates = new HashMap<String, Boolean>();
    public static final ModConfigSpec SERVER_SPEC;
    public static CommentedFileConfig serverConfigFile;
    public static ModConfig serverModConfig;

    private static void loadServerConfig() {
        Path configPath;
        Path path = configPath = serverModConfig != null ? serverModConfig.getFullPath() : null;
        if (configPath != null) {
            serverConfigFile = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().autosave().writingMode(WritingMode.REPLACE).build();
            serverConfigFile.load();
            for (String talisman : SERVER_TALISMAN_TOGGLES.keySet()) {
                talismanEnabledStates.put(talisman, (Boolean)SERVER_TALISMAN_TOGGLES.get(talisman).get());
            }
        }
    }

    public static boolean isTalismanEnabledServer(String talisman) {
        return talismanEnabledStates.getOrDefault(talisman, true);
    }

    public static List<String> getTalismanNames() {
        ArrayList<String> talismanNames = new ArrayList<String>();
        for (TalismanType type : TalismanType.values()) {
            talismanNames.add(type.name().toLowerCase());
        }
        return talismanNames;
    }

    static {
        SERVER_BUILDER.comment(new String[]{"###########################", "# Fargos Talismans Config #", "# Server-side settings    #", "###########################", "", "Each talisman can be enabled or disabled. Defaults to enabled.", ""});
        for (String talisman : ServerConfig.getTalismanNames()) {
            ModConfigSpec.BooleanValue toggle = SERVER_BUILDER.comment("Whether " + talisman + " is enabled on the server").define(talisman, true);
            SERVER_TALISMAN_TOGGLES.put(talisman, toggle);
        }
        SERVER_SPEC = SERVER_BUILDER.build();
        ServerConfig.loadServerConfig();
    }
}

