/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.arsocultas.common.mob_jar;

import com.hollingsworth.arsnouveau.api.item.inv.InventoryManager;
import com.hollingsworth.arsnouveau.api.item.inv.MultiInsertReference;
import com.hollingsworth.arsnouveau.api.mob_jar.JarBehavior;
import com.hollingsworth.arsnouveau.api.util.InvUtil;
import com.hollingsworth.arsnouveau.common.block.tile.MobJarTile;
import com.klikli_dev.occultism.api.OccultismAPI;
import com.klikli_dev.occultism.common.entity.job.CleanerJob;
import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.mystchonky.arsocultas.common.mob_jar.SpiritMenuWrapper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class SpiritBehaviour<T extends SpiritEntity>
extends JarBehavior<T> {
    public void use(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit, MobJarTile tile) {
        ItemStack duplicate;
        if (world.isClientSide) {
            return;
        }
        ItemStack heldStack = player.getItemInHand(handIn);
        SpiritEntity spirit = (SpiritEntity)this.entityFromJar(tile);
        if (player.isSecondaryUseActive() && heldStack.isEmpty()) {
            this.openScreen(player, spirit, tile);
            return;
        }
        if (this.canAcceptItemStack(spirit, heldStack) && ItemHandlerHelper.insertItemStacked((IItemHandler)spirit.inventory, (ItemStack)(duplicate = heldStack.copy()), (boolean)true).getCount() < duplicate.getCount()) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)spirit.inventory, (ItemStack)duplicate, (boolean)false);
            heldStack.setCount(remaining.getCount());
        }
    }

    public void tick(MobJarTile tile) {
        ItemStack duplicate;
        ItemEntity itemEntity;
        List itemEntities;
        Level level = tile.getLevel();
        if (level.isClientSide) {
            return;
        }
        SpiritEntity spirit = (SpiritEntity)this.entityFromJar(tile);
        if (!spirit.isInitialized()) {
            spirit.init();
        }
        if (level.getGameTime() % 40L == 0L && !(itemEntities = level.getEntitiesOfClass(ItemEntity.class, new AABB(tile.getBlockPos()).inflate(3.0), Entity::isAlive)).isEmpty() && (itemEntity = (ItemEntity)itemEntities.stream().filter(item -> OccultismAPI.get().canPickupItem((Entity)spirit, item).orElse(false)).findFirst().orElse(null)) != null && ItemHandlerHelper.insertItemStacked((IItemHandler)spirit.inventory, (ItemStack)(duplicate = itemEntity.getItem().copy()), (boolean)true).getCount() < duplicate.getCount()) {
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)spirit.inventory, (ItemStack)duplicate, (boolean)false);
            itemEntity.getItem().setCount(remaining.getCount());
        }
        spirit.getJob().ifPresent(spiritJob -> {
            if (spiritJob instanceof CleanerJob) {
                List inventories = InvUtil.adjacentInventories((Level)level, (BlockPos)tile.getBlockPos());
                if (inventories.isEmpty()) {
                    return;
                }
                InventoryManager manager = new InventoryManager(inventories);
                MultiInsertReference reference = manager.insertStackWithReference(spirit.getItemInHand(InteractionHand.MAIN_HAND));
                if (!reference.isEmpty()) {
                    ItemStack remainder = reference.getRemainder();
                    spirit.setItemInHand(InteractionHand.MAIN_HAND, remainder);
                    level.playSound(null, tile.getBlockPos(), SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 0.8f, 1.0f);
                }
            }
            spiritJob.update();
            tile.updateBlock();
        });
    }

    private boolean canAcceptItemStack(SpiritEntity spirit, ItemStack stack) {
        OccultismAPI api = OccultismAPI.get();
        if (api.getItemsToPickUp((Entity)spirit).isPresent()) {
            return ((List)api.getItemsToPickUp((Entity)spirit).get()).stream().anyMatch(item -> item.test(stack));
        }
        return false;
    }

    public void getTooltip(MobJarTile tile, List<Component> tooltips) {
        super.getTooltip(tile, tooltips);
    }

    public void openScreen(Player playerEntity, SpiritEntity spirit, MobJarTile tile) {
        SpiritMenuWrapper<SpiritEntity> menuProvider;
        SpiritJob currentJob = spirit.getJob().orElse(null);
        if (currentJob instanceof MenuProvider) {
            MenuProvider jobMenuProvider = (MenuProvider)currentJob;
            menuProvider = new SpiritMenuWrapper<MenuProvider>(jobMenuProvider, spirit);
        } else {
            menuProvider = new SpiritMenuWrapper<SpiritEntity>(spirit, spirit);
        }
        if (playerEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)playerEntity;
            serverPlayer.openMenu(menuProvider, buf -> buf.writeBlockPos(tile.getBlockPos()));
        }
    }
}

