/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block.plastic;

import mekanism.api.text.EnumColor;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class BlockPlasticFenceGate
extends FenceGateBlock
implements IColoredBlock,
IStateFluidLoggable {
    private final EnumColor color;

    public BlockPlasticFenceGate(EnumColor color) {
        super(BlockStateHelper.applyLightLevelAdjustments((BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(5.0f, 6.0f)), SoundEvents.FENCE_GATE_CLOSE, SoundEvents.FENCE_GATE_OPEN);
        this.color = color;
        this.registerDefaultState(BlockStateHelper.getDefaultState((BlockState)this.defaultBlockState()));
    }

    public EnumColor getColor() {
        return this.color;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement((Block)this, (BlockState)super.getStateForPlacement(context), (BlockPlaceContext)context);
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        return this.getFluid(state);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        this.updateFluids(state, world, currentPos);
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        BlockStateHelper.fillBlockStateContainer((Block)this, builder);
    }
}

