/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block.plastic;

import java.util.Optional;
import mekanism.additions.common.block.IStateExtendedFluidLoggable;
import mekanism.api.text.EnumColor;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.states.BlockStateHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;

public class BlockPlasticFence
extends FenceBlock
implements IColoredBlock,
IStateExtendedFluidLoggable {
    private final EnumColor color;

    public BlockPlasticFence(EnumColor color) {
        super(BlockStateHelper.applyLightLevelAdjustments((BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(color.getMapColor()).strength(5.0f, 6.0f)));
        this.color = color;
        this.registerDefaultState(BlockStateHelper.getDefaultState((BlockState)this.defaultBlockState()));
    }

    public EnumColor getColor() {
        return this.color;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        BlockStateHelper.fillBlockStateContainer((Block)this, builder);
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement((Block)this, (BlockState)super.getStateForPlacement(context), (BlockPlaceContext)context);
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        return this.getFluid(state);
    }

    @Override
    public boolean placeLiquid(@NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull FluidState fluidState) {
        return IStateExtendedFluidLoggable.super.placeLiquid(world, pos, state, fluidState);
    }

    @Override
    public boolean canPlaceLiquid(Player player, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Fluid fluid) {
        return IStateExtendedFluidLoggable.super.canPlaceLiquid(player, world, pos, state, fluid);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        this.updateFluids(state, world, currentPos);
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    @Override
    @NotNull
    public ItemStack pickupBlock(Player player, @NotNull LevelAccessor world, @NotNull BlockPos pos, @NotNull BlockState state) {
        return IStateExtendedFluidLoggable.super.pickupBlock(player, world, pos, state);
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return IStateExtendedFluidLoggable.super.getPickupSound();
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound(@NotNull BlockState state) {
        return IStateExtendedFluidLoggable.super.getPickupSound(state);
    }
}

