/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common.block;

import mekanism.additions.common.entity.EntityObsidianTNT;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IStateFluidLoggable;
import mekanism.common.util.VoxelShapeUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockObsidianTNT
extends TntBlock
implements IStateFluidLoggable {
    private static final VoxelShape bounds = VoxelShapeUtils.combine((VoxelShape[])new VoxelShape[]{BlockObsidianTNT.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0), BlockObsidianTNT.box((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0), BlockObsidianTNT.box((double)12.5, (double)11.8, (double)12.5, (double)13.5, (double)13.8, (double)13.5), BlockObsidianTNT.box((double)12.5, (double)11.5, (double)7.5, (double)13.5, (double)13.5, (double)8.5), BlockObsidianTNT.box((double)12.5, (double)11.8, (double)2.5, (double)13.5, (double)13.8, (double)3.5), BlockObsidianTNT.box((double)2.5, (double)11.8, (double)12.5, (double)3.5, (double)13.8, (double)13.5), BlockObsidianTNT.box((double)2.5, (double)11.5, (double)7.5, (double)3.5, (double)13.5, (double)8.5), BlockObsidianTNT.box((double)2.5, (double)11.8, (double)2.5, (double)3.5, (double)13.8, (double)3.5), BlockObsidianTNT.box((double)7.5, (double)11.5, (double)12.5, (double)8.5, (double)13.5, (double)13.5), BlockObsidianTNT.box((double)7.5, (double)11.5, (double)2.5, (double)8.5, (double)13.5, (double)3.5), BlockObsidianTNT.box((double)7.5, (double)11.8, (double)7.5, (double)8.5, (double)13.8, (double)8.5), BlockObsidianTNT.box((double)11.0, (double)-1.0, (double)11.0, (double)15.0, (double)12.0, (double)15.0), BlockObsidianTNT.box((double)11.0, (double)-1.0, (double)6.0, (double)15.0, (double)12.0, (double)10.0), BlockObsidianTNT.box((double)11.0, (double)-1.0, (double)1.0, (double)15.0, (double)12.0, (double)5.0), BlockObsidianTNT.box((double)6.0, (double)-1.0, (double)1.0, (double)10.0, (double)12.0, (double)5.0), BlockObsidianTNT.box((double)6.0, (double)-1.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), BlockObsidianTNT.box((double)6.0, (double)-1.0, (double)11.0, (double)10.0, (double)12.0, (double)15.0), BlockObsidianTNT.box((double)1.0, (double)-1.0, (double)6.0, (double)5.0, (double)12.0, (double)10.0), BlockObsidianTNT.box((double)1.0, (double)-1.0, (double)11.0, (double)5.0, (double)12.0, (double)15.0), BlockObsidianTNT.box((double)1.0, (double)-1.0, (double)1.0, (double)5.0, (double)12.0, (double)5.0)});

    public BlockObsidianTNT() {
        super(BlockStateHelper.applyLightLevelAdjustments((BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_BLACK).ignitedByLava()));
        this.registerDefaultState(BlockStateHelper.getDefaultState((BlockState)this.defaultBlockState()));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        BlockStateHelper.fillBlockStateContainer((Block)this, builder);
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        return BlockStateHelper.getStateForPlacement((Block)this, (BlockState)super.getStateForPlacement(context), (BlockPlaceContext)context);
    }

    public int getFlammability(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull Direction face) {
        return 75;
    }

    public void onCaughtFire(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @Nullable Direction side, @Nullable LivingEntity igniter) {
        if (!world.isClientSide && BlockObsidianTNT.createAndAddEntity(world, pos, igniter)) {
            world.gameEvent((Entity)igniter, (Holder)GameEvent.PRIME_FUSE, pos);
        }
    }

    public void wasExploded(Level world, @NotNull BlockPos pos, @NotNull Explosion explosion) {
        EntityObsidianTNT tnt;
        if (!world.isClientSide && (tnt = EntityObsidianTNT.create(world, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, explosion.getIndirectSourceEntity())) != null) {
            tnt.setFuse((short)(world.random.nextInt(tnt.getFuse() / 4) + tnt.getFuse() / 8));
            world.addFreshEntity((Entity)tnt);
        }
    }

    protected boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType type) {
        return false;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return bounds;
    }

    @NotNull
    protected FluidState getFluidState(@NotNull BlockState state) {
        return this.getFluid(state);
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor world, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        this.updateFluids(state, world, currentPos);
        return super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public static boolean createAndAddEntity(@NotNull Level world, @NotNull BlockPos pos, @Nullable LivingEntity igniter) {
        EntityObsidianTNT tnt = EntityObsidianTNT.create(world, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, igniter);
        if (tnt != null) {
            world.addFreshEntity((Entity)tnt);
            world.playSound(null, tnt.getX(), tnt.getY(), tnt.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS);
            return true;
        }
        return false;
    }
}

