/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.client;

import io.netty.channel.local.LocalAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import mekanism.additions.client.voice.VoiceClient;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.common.Mekanism;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;

@Mod(value="mekanismadditions", dist={Dist.CLIENT})
public class AdditionsClient {
    private static VoiceClient voiceClient;

    public AdditionsClient(ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
    }

    public static void reset() {
        if (voiceClient != null) {
            voiceClient.disconnect();
            voiceClient = null;
        }
    }

    public static void launch() {
        if (MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            SocketAddress address;
            ClientPacketListener connection = Minecraft.getInstance().getConnection();
            SocketAddress socketAddress = address = connection == null ? null : connection.getConnection().getRemoteAddress();
            if (address instanceof LocalAddress) {
                voiceClient = new VoiceClient("127.0.0.1");
                voiceClient.start();
            } else if (address instanceof InetSocketAddress) {
                InetSocketAddress socketAddress2 = (InetSocketAddress)address;
                voiceClient = new VoiceClient(socketAddress2.getHostString());
                voiceClient.start();
            } else {
                Mekanism.logger.error("Unknown connection address detected, voice client will not launch.");
            }
        }
    }
}

