/*
 * Decompiled with CFR 0.152.
 */
package aztech.modern_industrialization.stats;

import aztech.modern_industrialization.stats.PlayerStatistics;
import aztech.modern_industrialization.util.MISavedData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class PlayerStatisticsData
extends MISavedData {
    private final Map<UUID, PlayerStatistics> stats = new HashMap<UUID, PlayerStatistics>();
    private final Function<UUID, PlayerStatistics> statsFactory = uuid -> new PlayerStatistics(this, (UUID)uuid);
    private static final String NAME = "modern_industrialization_player_stats";
    private static final SavedData.Factory<PlayerStatisticsData> FACTORY = new SavedData.Factory(PlayerStatisticsData::new, PlayerStatisticsData::new);

    private PlayerStatisticsData(CompoundTag tag, HolderLookup.Provider registries) {
        for (String key : tag.getAllKeys()) {
            UUID uuid2 = UUID.fromString(key);
            this.stats.put(uuid2, new PlayerStatistics(this, uuid2, tag.getCompound(key)));
        }
    }

    private PlayerStatisticsData() {
    }

    public PlayerStatistics get(UUID uuid) {
        Objects.requireNonNull(uuid);
        return this.stats.computeIfAbsent(uuid, this.statsFactory);
    }

    public PlayerStatistics get(Player player) {
        return this.get(player.getUUID());
    }

    public boolean isDirty() {
        return true;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        for (Map.Entry<UUID, PlayerStatistics> entry : this.stats.entrySet()) {
            tag.put(entry.getKey().toString(), (Tag)entry.getValue().toTag());
        }
        return tag;
    }

    public static PlayerStatisticsData get(MinecraftServer server) {
        ServerLevel overworld = server.getLevel(ServerLevel.OVERWORLD);
        Objects.requireNonNull(overworld, "Couldn't find overworld");
        return (PlayerStatisticsData)overworld.getDataStorage().computeIfAbsent(FACTORY, NAME);
    }
}

